﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command
{
    class UpdateCommandArg:CommandArg
    {
        TaskData _data;
        

        public TaskData PreparedTaskData
        {
            get { return _data; }
        }

        public bool changeDialog
        {
            get;
            private set;
        }

        public void split(string arguments)
        {
            string[] spaceSplitData = arguments.Split(' ');
            
            string sortID = spaceSplitData[1];
            List<string> otherParamList = new List<string>();
            for (int i = 2; i < spaceSplitData.Length; i++)
            {
                otherParamList.Add(spaceSplitData[i]);
            }
            TaskDataAccessor taskAccessor = TaskDataAccessor.getObject;

            int sortIDNum;
            if (int.TryParse(sortID, out sortIDNum))
            {
                _data = taskAccessor.getTask(sortIDNum);

            }
            else
            {
                _data = null;
                return;
            }

            changeDialog = true;
            foreach (string options in otherParamList)
            {
                string[] optionData = options.Split(':');
                switch (optionData[0].ToUpper())
                {
                    case "@":
                        //時間帯
                        if (optionData[1].Length == 1)
                        {
                            _data.TimeArea = optionData[1];
                            changeDialog = false;
                        }
                        break;
                    case "D":
                        //日付
                        if (optionData[1].Length == 4 || optionData[1].Length == 8)
                        {
                            _data.DoDate = new DateComponent(optionData[1]);
                            changeDialog = false;
                        }
                        break;
                    case "C":
                        //カテゴリ
                        
                        CategoryData categData = CategoryDataAccessor.getObject.getCategoryFromName(optionData[1]);
                        if (categData != null)
                        {
                            _data.Category = optionData[1];
                            _data.CategID = categData.CategId;
                            
                            changeDialog = false;
                        }
                        break;
                    case "F":
                        decimal forcastTime;
                        string timestr;
                        if (optionData[1].ToLower().EndsWith("h"))
                        {
                            timestr = optionData[1].Substring(0, optionData[1].Length - 1);
                            if (decimal.TryParse(timestr, out forcastTime))
                            {
                                _data.ForecastMin = decimal.ToInt32(forcastTime * 60);
                                changeDialog = false;
                            }
                        }
                        else if (decimal.TryParse(optionData[1], out forcastTime))
                        {
                            _data.ForecastMin = decimal.ToInt32(forcastTime);
                            changeDialog = false;
                        }

                        break;
                    default:
                        //なにもない場合はコンテンツ(最初の記載を是とする)
                        if (!string.IsNullOrEmpty(_data.Contents))
                        {
                            _data.Contents = optionData[0];
                            changeDialog = false;
                        }
                        break;
                }
            }
        }

        public bool getSplitResult()
        {
            return _data != null;
        }
    }
}
