﻿using System;
using System.Collections.Generic;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.accessor;

namespace com.andoutomo.kybernetes.command
{
    class UpdateCommand:AbCommand
    {
        string message;
        protected override bool execute()
        {
            UpdateCommandArg param = (UpdateCommandArg)argument;
            TaskData data = param.PreparedTaskData;
            if (data == null)
            {
                base.errorType = ErrorType.DataNotFound;
                return false;
            }
            if (param.changeDialog)
            {
                #region 実施事項
                data.Contents = form.showInputBox("実施事項を入力してください。",data.Contents);
                if (data.Contents == null || data.Contents == string.Empty)
                {
                    message = "処理を中断しました。";
                    return false;
                }
                #endregion
                #region 実行日付
                string dateStr = form.showInputBox("日付をyyyyMMddかMMddで入力してください。空の場合は今日とします。",data.DoDate.getDateString("yyyyMMdd"));
                if (dateStr == null)
                {
                    message = "処理を中断しました。";
                    return false;
                }

                if (dateStr == string.Empty)
                {
                    dateStr = DateTime.Today.ToString("yyyyMMdd");
                }
                try
                {
                    data.DoDate = new data.DateComponent(dateStr);
                }
                catch (Exception e)
                {
                    message = "日付に不備がありました。お手数ですが最初からやり直してください。";
                    return false;
                }
                #endregion
                #region タイムエリア
                data.TimeArea = form.showInputBox("タイムエリアを選択してください(A-Z)",data.TimeArea).ToUpper();
                if (data.TimeArea == null || data.TimeArea == string.Empty)
                {
                    message = "処理を中断しました。";
                    return false;
                }
                #endregion
                #region カテゴリ
                CategoryDataAccessor dataAccessor = CategoryDataAccessor.getObject;
                //string wkStr = form.showInputBox("カテゴリを記入してください。");
                List<CategoryData> allList = dataAccessor.getAllCategory();
                List<SimpleDataBean> dropdownList = new List<SimpleDataBean>();

                foreach (CategoryData categList in allList)
                {
                    dropdownList.Add(categList.dataForDropDown);
                }

                CategoryData selectedCategory = dataAccessor.getCategoryFromID(data.CategID);
                string wkStr;
                if (selectedCategory == null)
                {
                    wkStr = form.showDropBoxInputBox(dropdownList, "カテゴリを入力してください。");
                }
                else
                {
                    wkStr = form.showDropBoxInputBox(dropdownList, "カテゴリを入力してください。", selectedCategory.Category);
                }

                if (wkStr == null)
                {
                    message = "処理を中断しました。";
                    return false;
                }

                CategoryData categData = dataAccessor.getCategoryFromName(wkStr);
                if (categData != null)
                {
                    data.CategID = categData.CategId;
                }
                else
                {
                    data.CategID = 99;
                }
                #endregion

                string wkFrcstMin = form.showInputBox("見積時間を入力してください。",data.ForecastMin.ToString());
                if (wkFrcstMin == null || wkFrcstMin == string.Empty)
                {
                    message = "処理を中断しました。";
                    return false;

                }
                if (wkFrcstMin.ToLower().EndsWith("h"))
                {
                    decimal forcastTime;
                    string timestr = wkFrcstMin.Substring(0, wkFrcstMin.Length - 1);
                    if (decimal.TryParse(timestr, out forcastTime))
                    {
                        data.ForecastMin = decimal.ToInt32(forcastTime * 60);
                    }
                }
                else
                {
                    data.ForecastMin = Convert.ToInt32(wkFrcstMin);
                }
            }

            TaskDataAccessor accessor = TaskDataAccessor.getObject;
            
            //成功した場合のメッセージをここで作っておく
            message = "タスクNo." + data.SortID + "を更新しました。";
            return accessor.updateTask(data);

        }

        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            if (message == string.Empty)
            {
                return base.DefaultErrorMessage;
            }
            else
            {
                return message;
            }
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
