﻿using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command
{
    public class ListCommandArg:CommandArg
    {
        private DateComponent searchDateInner;


        public DateComponent SearchDate
        {
            get { return searchDateInner; }
        }

        public virtual bool SearchAll
        {
            get;
            private set;
        }
        public virtual bool SearchRemain
        {
            get;
            private set;
        }
        public virtual bool SearchGoing
        {
            get;
            private set;
        }
        public void split(string arguments)
        {
            string[] spaceSplitData = arguments.Split(' ');

            if (spaceSplitData.Length == 1)
            {
                searchDateInner = null;
            }
            else if (spaceSplitData.Length >= 2)
            {
                if (spaceSplitData[1].ToLower() == "all")
                {
                    SearchAll = true;
                    SearchRemain = false;
                    SearchGoing = false;
                }
                else if (spaceSplitData[1].ToLower() == "remain")
                {
                    SearchAll = false;
                    SearchRemain = true;
                    SearchGoing = false;
                }
                else if (spaceSplitData[1].ToLower() == "going")
                {
                    SearchAll = false;
                    SearchRemain = false;
                    SearchGoing = true;
                }
                else
                {
                    SearchAll = false;
                    SearchRemain = false;
                    SearchGoing = false;
                    searchDateInner = new DateComponent(spaceSplitData[1]);
                }

            }
        }

        public bool getSplitResult()
        {
            return true;
        }
    }
}
