﻿using System;
using System.Collections.Generic;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.view;

namespace com.andoutomo.kybernetes.command
{
    public class ListCommand:AbCommand
    {
        protected override bool execute()
        {
            ListCommandArg arguments = (ListCommandArg)base.argument;
            DateComponent searchDate = arguments.SearchDate;

            DateComponent todayDate = SettingDataAccessor.getObject.getToday();
            TaskDataAccessor dataAccess = TaskDataAccessor.getObject;
            List<TaskData> dataList;
                if (arguments.SearchAll)
                {
                    dataList = dataAccess.getAllTaskList();
                }
                else if (arguments.SearchRemain)
                {
                    dataList = dataAccess.getRemainTaskList();
                }
                else if (arguments.SearchGoing)
                {
                    dataList = dataAccess.getGoingTaskList();
                }
                else if (searchDate != null)
                {
                    dataList = dataAccess.getDailyTaskList(searchDate);
                }

                else
                {
                    dataList = dataAccess.getToDayTaskList();
                }
                if (dataList.Count > 500)
                {
                    if (YesNoDialog.show("件数が500件を超えています。表示に時間がかかりますがよろしいでしょうか？") == false)
                    {
                        message = "表示を中止しました。なお大量タスク表示の際はexpの使用をおすすめします。";
                        return true;
                    }
                }


            form.clearPanel();
            string wkAreaForIndex = "";
            foreach (TaskData data in dataList)
            {
                data.Today = todayDate;
                if (!data.isComplete)
                {
                    if (wkAreaForIndex != data.TimeArea)
                    {
                        string wkIndex = "- " + data.TimeArea + " - on " + data.DoDate.getDateString("yyyy/MM/dd");
                        form.addIndexPanel(wkIndex);
                    }
                
                wkAreaForIndex = data.TimeArea;
                }
                form.addPanel(data);
                
            }

            message = string.Empty;
            return true;
        }
        string message;
        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
