﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command.reference
{
    public class EstimateCommand:AbCommand
    {
        protected override bool execute()
        {
            EstimateCommandArg param = (EstimateCommandArg)argument;
            string targetDate=string.Empty;

            //タスクリストを取得
            List<TaskData> taskList;
            if (param.targetDate == null)
            {
                taskList = TaskDataAccessor.getObject.getToDayTaskList();
                targetDate="本日";
            }
            else
            {
                taskList = TaskDataAccessor.getObject.getDailyTaskList(param.targetDate);
                targetDate = param.targetDate.getDateString();

            }
            //タイムエリアマスタからマスターリストを取得
            List<TimeAreaCalcData> timeAreaList = TimeAreaDataAccessor.getObject.getAllTimeAreaForCalc();

            // タスクごとに、タイムエリアマスタの合致するポイントを見つけて
            int minuteRemains = 0;
            foreach (TaskData taskData in taskList)
            {
                foreach (TimeAreaCalcData area in timeAreaList)
                {
                    if (taskData.TimeArea.Equals(area.AreaStr))
                    {
                        // そこに値を加算する
                        // 見積もり時間
                        area.ForcastMin += taskData.ForecastMin;
                        // 実績時間
                        area.ActualMin += taskData.RealMin;
                        

                        // 終了していないタスクの時間
                        if (taskData.isComplete == false)
                        {
                            minuteRemains += taskData.ForecastMin;
                            // 残り時間
                            area.RemainMin += taskData.ForecastMin;
                        }
                    }
                }
            }

            List<string> msgList = new List<string>();
            //msgList.Add(targetDate + "の作業見積もり及び実績");
            //msgList.Add(string.Empty);
            msgList.Add(" @ FROM-TO     Span  Forecast REAL  REMAIN ");
            foreach (TimeAreaCalcData area_ in timeAreaList)
            {
                // image: @ FROM-TO     Span  Forecast REAL  REMAIN 
                // image: A 09:00-12:00  3:00  2:40     3:20  1:10
                string estimateStr = " " + area_.AreaStr;
                estimateStr += " ";
                estimateStr += getFiveLengthTimeStr(area_.StartTime);
                estimateStr += "-";
                estimateStr += getFiveLengthTimeStr(area_.EndTime);
                estimateStr += " ";
                estimateStr += new TimeComponent(area_.Span).ToString();
                estimateStr += " ";
                estimateStr += new TimeComponent(area_.ForcastMin).ToString();
                estimateStr += "    ";
                estimateStr += new TimeComponent(area_.ActualMin).ToString();
                estimateStr += " ";
                estimateStr += new TimeComponent(area_.RemainMin).ToString();

                msgList.Add(estimateStr);
            }
            msgList.Add(string.Empty);
            msgList.Add("現在時刻    : " + TimeComponent.justNow().ToString());
            msgList.Add("残り作業    : " + new TimeComponent(minuteRemains).ToString());
            msgList.Add("予想終了時刻: " + TimeComponent.justNow().add(minuteRemains).ToString());
            //msgList.Add(string.Empty);

            form.addMultiText(msgList);
            return true;
        }

        protected string getFiveLengthTimeStr(TimeComponent time)
        {
            string wkStr = time.ToString();
            if (wkStr.Length == 4)
            {
                wkStr = " " + wkStr;
            }
            return wkStr;
        }

        protected override string turnMessage()
        {
            return string.Empty;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
