﻿using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.view;

namespace com.andoutomo.kybernetes.command.CRUD
{
    class DeleteCommand:AbCommand
    {
        int targetCount;
        string message=string.Empty;
        protected override bool execute()
        {
            DeleteCommandArg param = (DeleteCommandArg)argument;

            TaskDataAccessor accessor = TaskDataAccessor.getObject;
            targetCount = accessor.countDeleteTargetTask(param.targetIDFrom, param.targetIDTo);
            if (targetCount == 0)
            {
                message = "削除対象がありません。";
                return false;
            }
            if (YesNoDialog.show(targetCount + "件のタスクを削除します。よろしいですか？"))
            {
                accessor.deleteTask(param.targetIDFrom, param.targetIDTo);
                CommentDataAccessor.getObject.deleteCommentWithTask();
                return true;
            }
            else
            {
                message = "削除処理を中断しました。";
                return false;
            }

        }

        protected override string turnMessage()
        {
            return targetCount + "件のタスクを削除しました。";
        }

        protected override string turnErrorMessage()
        {
            if (string.IsNullOrEmpty(message))
            {
                return base.DefaultErrorMessage;
            }
            else
            {
                return message;
            }

        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
