/*
 syscall_name - system call information for RedHat Enterprise Linux AS 4
 Copyright (c) 2006,2007 Hitachi,Ltd.,
 Created by Satoru Moriya <satoru.moriya.br@hitachi.com>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "syscall_name.h"

struct syscall_attribute syscall_name[] = {
	[0] = {"ni_syscall", 0, 0},
	[1] = {"exit", 1, 0},
	[2] = {"read", 3, 2},
	[3] = {"write", 3, 2},
	[4] = {"open", 3, 1},
	[5] = {"close", 1, 0},
	[6] = {"creat", 2, 1},
	[7] = {"link", 2, 3},
	[8] = {"unlink", 1, 1},
	[9] = {"execve", 3, 0},
	[10] = {"chdir", 1, 1},
	[11] = {"fchdir", 1, 0},
	[12] = {"utimes", 2, 3},
	[13] = {"mknod", 3, 1},
	[14] = {"chmod", 2, 1},
	[15] = {"chown", 3, 1},
	[16] = {"lseek", 3, 0},
	[17] = {"getpid", 0, 0},
	[18] = {"getppid", 0, 0},
	[19] = {"mount", 5, 23},
	[20] = {"umount", 2, 1}, 
	[21] = {"setuid", 1, 0},
	[22] = {"getuid", 0, 0},
	[23] = {"geteuid", 0, 0},
	[24] = {"ptrace", 9, 0},
	[25] = {"access", 2, 1},
	[26] = {"sync", 0, 0},
	[27] = {"fsync", 1, 0},
	[28] = {"fdatasync", 1, 0},
	[29] = {"kill", 2, 0},
	[30] = {"rename", 2, 3},
	[31] = {"mkdir", 2, 1},
	[32] = {"rmdir", 1, 1},
	[33] = {"dup", 1, 0},
	[34] = {"pipe", 9, 0},   
	[35] = {"times", 1, 1},
	[36] = {"brk", 1, 0},
	[37] = {"setgid", 1, 0},
	[38] = {"getgid", 0, 0},
	[39] = {"getegid", 0, 0},
	[40] = {"acct", 1, 1},
	[41] = {"ioctl", 3, 4},
	[42] = {"fcntl", 3, 4},
	[43] = {"umask", 1, 0},
	[44] = {"chroot", 1, 1},
	[45] = {"ustat", 2, 2},
	[46] = {"dup2", 2, 0},
	[47] = {"setreuid", 2, 0},
	[48] = {"setregid", 2, 0},
	[49] = {"getresuid", 3, 7},
	[50] = {"setresuid", 3, 0},
	[51] = {"getresgid", 3, 7},
	[52] = {"setresgid", 3, 0},
	[53] = {"getgroups", 2, 2},
	[54] = {"setgroups", 2, 2},
	[55] = {"getpgid", 1, 0},
	[56] = {"setpgid", 2, 0},
	[57] = {"setsid", 0, 0},
	[58] = {"getsid", 1, 0},
	[59] = {"sethostname", 2, 1},
	[60] = {"setrlimit", 2, 2},
	[61] = {"getrlimit", 2, 2},
	[62] = {"getrusage", 2, 2},
	[63] = {"gettimeofday", 2, 3},
	[64] = {"settimeofday", 2, 3},
	[65] = {"select", 5, 30},
	[66] = {"poll", 3, 1},
	[67] = {"symlink", 2, 3},
	[68] = {"readlink", 3, 3},
	[69] = {"uselib", 1, 1},
	[70] = {"swapon", 2, 1},
	[71] = {"swapoff", 1, 1},
	[72] = {"reboot", 4, 8},
	[73] = {"truncate", 2, 1},
	[74] = {"ftruncate", 2, 0},
	[75] = {"fchmod", 2, 0},
	[76] = {"fchown", 2, 0},
	[77] = {"getpriority", 2, 0},
	[78] = {"setpriority", 3, 0},
	[79] = {"statfs", 2, 3},
	[80] = {"fstatfs", 2, 2},
	[81] = {"gettid", 0, 0},
	[82] = {"semget", 3, 0},
	[83] = {"semop", 3, 2},
	[84] = {"semctl", 4, 0},
	[85] = {"msgget", 2, 0},
	[86] = {"msgsnd", 4, 2},
	[87] = {"msgrcv", 5, 2},
	[88] = {"msgctl", 3, 4},
	[89] = {"shmget", 3, 0},
	[90] = {"shmat", 3, 2},
	[91] = {"shmdt", 1, 1},
	[92] = {"shmctl", 3, 4},
	[93] = {"syslog", 3, 2},
	[94] = {"setitimer", 3, 6},
	[95] = {"getitimer", 2, 2},
	[96] = {"old_stat", 2, 0},  /* not implemented */
	[97] = {"old_lstat", 2, 0}, /* not implemented */
	[98] = {"old_fstat", 2, 0}, /* not implemented */
	[99] = {"vhangup", 0, 0},
	[100] = {"lchown", 3, 1},
	[101] = {"remap_file_pages", 5, 0},
	[102] = {"wait4", 4, 10},
	[103] = {"sysinfo", 1, 1},
	[104] = {"clone", 5, 0},
	[105] = {"setdomainname", 2, 1},
	[106] = {"newuname", 1, 1},
	[107] = {"adjtimex", 1, 1},
	[108] = {"create_module", 2, 0},   /* not implemented */
	[109] = {"init_module", 3, 5},
	[110] = {"delete_module", 2, 1},
	[111] = {"get_kernel_syms", 1, 0}, /* not implemented */
	[112] = {"query_module", 5, 0},    /* not implemented */
	[113] = {"quotactl", 4, 10},
	[114] = {"bdflush", 2, 0},
	[115] = {"sysfs", 3, 0},
	[116] = {"personality", 1, 0},
	[117] = {"afs_syscall", 5, 0},     /* not implemented */
	[118] = {"setfsuid", 1, 0},
	[119] = {"setfsgid", 1, 0},
	[120] = {"getdents", 3, 2},
	[121] = {"flock", 2, 0},
	[122] = {"readv", 3, 2},
	[123] = {"writev", 3, 2},
	[124] = {"pread64", 4, 2},
	[125] = {"pwrite64", 4, 2},
	[126] = {"sysctl", 1, 1},
	[127] = {"mmap", 6, 0},
	[128] = {"munmap", 2, 0},
	[129] = {"mlock", 2, 0},
	[130] = {"mlockall", 1, 0},
	[131] = {"mprotect", 3, 0},
	[132] = {"mremap", 5, 0},
	[133] = {"msync", 3, 0},
	[134] = {"munlock", 2, 0},
	[135] = {"munlockall", 0, 0},
	[136] = {"sched_getparam", 2, 2},
	[137] = {"sched_setparam", 2, 2},
	[138] = {"sched_getscheduler", 1, 1},
	[139] = {"sched_setscheduler", 3, 4},
	[140] = {"sched_yield", 0, 0},
	[141] = {"sched_get_priority_max", 1, 0},
	[142] = {"sched_get_priority_min", 1, 0},
	[143] = {"sched_rr_get_interval", 2, 2},
	[144] = {"nanosleep", 2, 3},
	[145] = {"nfsservctl", 3, 6},
	[146] = {"prctl", 5, 0},
	[147] = {"getpagesize", 0, 0},
	[148] = {"mmap2", 6, 0},
	[149] = {"pciconfig_read", 5, 16},
	[150] = {"pciconfig_write", 5, 16},
	[151] = {"perfmonctl", 4, 4},
	[152] = {"sigaltstack", 9, 3},
	[153] = {"rt_sigaction", 4, 6},
	[154] = {"rt_sigpending", 2, 1},
	[155] = {"rt_sigprocmask", 4, 6},
	[156] = {"rt_sigqueueinfo", 3, 4},
	[157] = {"rt_sigreturn", 0, 0},
	[158] = {"rt_sigsuspend", 8, 0},
	[159] = {"rt_sigtimedwait", 4, 7},
	[160] = {"getcwd", 2, 1},
	[161] = {"capget", 2, 0},
	[162] = {"capset", 2, 0},
	[163] = {"sendfile", 4, 4},
	[164] = {"getpmsg", 5, 0}, /* not implemented */
	[165] = {"putpmsg", 5, 0}, /* not implemented */
	[166] = {"socket", 3, 0},
	[167] = {"bind", 3, 2},
	[168] = {"connect", 3, 2},
	[169] = {"listen", 2, 0},
	[170] = {"accept", 3, 6},
	[171] = {"getsockname", 3, 6},
	[172] = {"getpeername", 3, 6},
	[173] = {"socketpair", 4, 8},
	[174] = {"send", 4, 2},
	[175] = {"sendto", 6, 18},
	[176] = {"recv", 4, 2},
	[177] = {"recvfrom", 6, 50},
	[178] = {"shutdown", 2, 0},
	[179] = {"setsockopt", 5, 8},
	[180] = {"getsockopt", 5, 24},
	[181] = {"sendmsg", 3, 2},
	[182] = {"recvmsg", 3, 2},
	[183] = {"pivot_root", 2, 3},
	[184] = {"mincore", 3, 4},
	[185] = {"madvise", 3, 0},
	[186] = {"stat", 2, 3},
	[187] = {"lstat", 2, 3},
	[188] = {"fstat", 2, 2},
	[189] = {"clone2", 6, 0},
	[190] = {"getdents64", 3, 2},
	[191] = {"getunwind", 2, 1},
	[192] = {"readahead", 3, 0},
	[193] = {"setxattr", 5, 7},
	[194] = {"lsetxattr", 5, 7},
	[195] = {"fsetxattr", 5, 6},
	[196] = {"getxattr", 4, 7},
	[197] = {"lgetxattr", 4, 7},
	[198] = {"fgetxattr", 4, 6},
	[199] = {"listxattr", 3, 3},
	[200] = {"llistxattr", 3, 3},
	[201] = {"flistxattr", 3, 2},
	[202] = {"removexattr", 2, 3},
	[203] = {"lremovexattr", 2, 3},
	[204] = {"fremovexattr", 2, 2},
	[205] = {"tkill", 2, 0},
	[206] = {"futex", 6, 25},
	[207] = {"sched_setaffinity", 3, 4},
	[208] = {"sched_getaffinity", 3, 4},
	[209] = {"set_tid_address", 1, 1},
	[210] = {"fadvise64", 4, 0},
	[211] = {"tgkill", 3, 0},
	[212] = {"exit_group", 1, 0},
	[213] = {"lookup_dcookie", 3, 2},
	[214] = {"io_setup", 2, 2},
	[215] = {"io_destroy", 1, 0},
	[216] = {"io_getevents", 5, 24},
	[217] = {"io_submit", 3, 4},
	[218] = {"io_cancel", 3, 6},
	[219] = {"epoll_create", 1, 0},
	[220] = {"epoll_ctl", 4, 8},
	[221] = {"epoll_wait", 4, 2},
	[222] = {"restart_syscall", 0, 0},
	[223] = {"semtimedop", 4, 10},
	[224] = {"timer_create", 3, 6},
	[225] = {"timer_settime", 4, 12},
	[226] = {"timer_gettime", 2, 2},
	[227] = {"timer_getoverrun", 1, 0},
	[228] = {"timer_delete", 1, 0},
	[229] = {"clock_settime", 2, 2},
	[230] = {"clock_gettime", 2, 2},
	[231] = {"clock_getres", 2, 2},
	[232] = {"clock_nanosleep", 4, 12},
	[233] = {"fstatfs64", 3, 4},
	[234] = {"statfs64", 3, 5},
	[235] = {"mbind", 6, 8},
	[236] = {"get_mempolicy", 5, 3},
	[237] = {"set_mempolicy", 3, 2},
	[238] = {"mq_open", 4, 9},
	[239] = {"mq_unlink", 1, 1},
	[240] = {"mq_timedsend", 5, 18},
	[241] = {"mq_timedreceive", 5, 26},
	[242] = {"mq_notify", 2, 2},
	[243] = {"mq_getsetattr", 3, 6},
	[244] = {"kexec_load", 4, 5},
	[245] = {"vserver", 5, 0}, /* not implemented */
	[246] = {"waitid", 5, 20},
	[247] = {"add_key", 5, 7},
	[248] = {"request_key", 4, 7},
	[249] = {"keyctl", 5, 0},
	[250] = {"ioprio_set", 3, 0},
	[251] = {"ioprio_get", 2, 0},
	[252] = {"set_zone_reclaim", 3, 0},
	[253] = {"inotify_init", 0, 0},
	[254] = {"inotify_add_watch", 3, 2},
	[255] = {"inotify_rm_watch", 2, 0},
	[256] = {"migrate_pages", 4, 12},
	[257] = {"openat", 4, 2},
	[258] = {"mkdirat", 3, 2},
	[259] = {"mknodat", 4, 2},
	[260] = {"fchownat", 5, 2},
	[261] = {"futimesat", 3, 6},
	[262] = {"newstatat", 4, 6},
	[263] = {"unlinkat", 3, 2},
	[264] = {"renameat", 4, 10},
	[265] = {"linkat", 5, 10},
	[266] = {"symlinkat", 3, 5},
	[267] = {"readlinkat", 4, 6},
	[268] = {"fchmodat", 3, 2},
	[269] = {"faccessat", 3, 2},
	[270] = {"pselect", 6, 62},
	[271] = {"ppoll", 5, 15},
	[272] = {"unshare", 1, 0},
	[273] = {"splice", 6, 10},
	[274] = {"set_robust_list", 2, 1},
	[275] = {"get_robust_list", 3, 6},
	[276] = {"sync_file_range", 4, 0},
	[277] = {"tee", 3, 0},
	[278] = {"vmsplice", 4, 2},
	[279] = {"move_pages", 6, 28},
	[280] = {"getcpu", 3, 7}
};
