/*
 mbuffer -- buffer module
 Copyright (c) 2006,2007 Hitachi,Ltd.,
 Created by Satoru Moriya <satoru.moriya.br@hitachi.com>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MBUFFER_ARCH_H__
#define __MBUFFER_ARCH_H__

#include <asm/processor.h>
#include <asm/gcc_intrin.h>
#include <asm/uaccess.h>
#include "ctr.h"
#include "kstrax_ioc.h"
#include "kstrax_syscall_list.h"

#define SPECIFIED_FILE (kstrax_status.trace_syscall[KS_READ] == 1 && \
		       	kstrax_status.trace_syscall[KS_WRITE] == 1 && \
			kstrax_status.trace_syscall[KS_OPEN] == 1 && \
			kstrax_status.trace_syscall[KS_LINK] == 1 && \
			kstrax_status.trace_syscall[KS_UNLINK] == 1 && \
			kstrax_status.trace_syscall[KS_CHDIR] == 1 && \
			kstrax_status.trace_syscall[KS_FCHDIR] == 1 && \
			kstrax_status.trace_syscall[KS_MKNOD] == 1 && \
			kstrax_status.trace_syscall[KS_CHMOD] == 1 && \
			kstrax_status.trace_syscall[KS_CHOWN] == 1 && \
			kstrax_status.trace_syscall[KS_LSEEK] == 1 && \
			kstrax_status.trace_syscall[KS_MOUNT] == 1 && \
			kstrax_status.trace_syscall[KS_ACCESS] == 1 && \
			kstrax_status.trace_syscall[KS_RENAME] == 1 && \
			kstrax_status.trace_syscall[KS_MKDIR] == 1 && \
			kstrax_status.trace_syscall[KS_RMDIR] == 1 && \
			kstrax_status.trace_syscall[KS_ACCT] == 1 && \
			kstrax_status.trace_syscall[KS_CHROOT] == 1 && \
			kstrax_status.trace_syscall[KS_SYMLINK] == 1 && \
			kstrax_status.trace_syscall[KS_READLINK] == 1 && \
			kstrax_status.trace_syscall[KS_TRUNCATE] == 1 && \
			kstrax_status.trace_syscall[KS_STATFS] == 1 && \
			kstrax_status.trace_syscall[KS_STAT] == 1 && \
			kstrax_status.trace_syscall[KS_LSTAT] == 1 && \
			kstrax_status.trace_syscall[KS_LCHOWN] == 1 && \
			kstrax_status.trace_syscall[KS_GETCWD] == 1 && \
			kstrax_status.trace_syscall[KS_SENDFILE] == 1 && \
			kstrax_status.trace_syscall[KS_PIVOT_ROOT] == 1 && \
			kstrax_status.trace_syscall[KS_FSTAT] == 1 && \
			kstrax_status.trace_syscall[KS_SETXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LSETXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_GETXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LGETXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LISTXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_REMOVEXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_LREMOVEXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_FADVISE64] == 1 && \
			kstrax_status.trace_syscall[KS_LLISTXATTR] == 1 && \
			kstrax_status.trace_syscall[KS_OLD_STAT] == 1 && \
			kstrax_status.trace_syscall[KS_OLD_LSTAT] == 1 && \
			kstrax_status.trace_syscall[KS_OLD_FSTAT] == 1 && \
			kstrax_status.trace_syscall[KS_EXECVE] == 1)

#define SPECIFIED_NETWORK (kstrax_status->trace_syscall[KS_GETPMSG] == 1 && \
			   kstrax_status->trace_syscall[KS_PUTPMSG] == 1 && \
			   kstrax_status->trace_syscall[KS_SOCKET] == 1 && \
			   kstrax_status->trace_syscall[KS_BIND] == 1 && \
			   kstrax_status->trace_syscall[KS_CONNECT] == 1 && \
			   kstrax_status->trace_syscall[KS_LISTEN] == 1 && \
			   kstrax_status->trace_syscall[KS_ACCEPT] == 1 && \
			   kstrax_status->trace_syscall[KS_GETSOCKNAME] == 1 && \
			   kstrax_status->trace_syscall[KS_GETPEERNAME] == 1 && \
			   kstrax_status->trace_syscall[KS_SOCKETPAIR] == 1 && \
			   kstrax_status->trace_syscall[KS_SEND] == 1 && \
			   kstrax_status->trace_syscall[KS_SENDTO] == 1 && \
			   kstrax_status->trace_syscall[KS_RECV] == 1 && \
			   kstrax_status->trace_syscall[KS_RECVFROM] == 1 && \
			   kstrax_status->trace_syscall[KS_SHUTDOWN] == 1 && \
			   kstrax_status->trace_syscall[KS_SETSOCKOPT] == 1 && \
			   kstrax_status->trace_syscall[KS_GETSOCKOPT] == 1 && \
			   kstrax_status->trace_syscall[KS_SENDMSG] == 1 && \
			   kstrax_status->trace_syscall[KS_RECVMSG] == 1)

#define SPECIFIED_IPC (kstrax_status->trace_syscall[KS_SEMGET] == 1 && \
			   kstrax_status->trace_syscall[KS_SEMOP] == 1 && \
			   kstrax_status->trace_syscall[KS_SEMCTL] == 1 && \
			   kstrax_status->trace_syscall[KS_MSGGET] == 1 && \
			   kstrax_status->trace_syscall[KS_MSGSND] == 1 && \
			   kstrax_status->trace_syscall[KS_MSGRCV] == 1 && \
			   kstrax_status->trace_syscall[KS_MSGCTL] == 1 && \
			   kstrax_status->trace_syscall[KS_SHMGET] == 1 && \
			   kstrax_status->trace_syscall[KS_SHMAT] == 1 && \
			   kstrax_status->trace_syscall[KS_SHMDT] == 1 && \
			   kstrax_status->trace_syscall[KS_SHMCTL] == 1 && \
			   kstrax_status->trace_syscall[KS_SEMTIMEDOP] == 1)

#define SPECIFIED_PROCESS (kstrax_status.trace_syscall[KS_WAIT4] == 1 && \
			   kstrax_status.trace_syscall[KS_WAITID] == 1 && \
			   kstrax_status.trace_syscall[KS_EXIT_GROUP] == 1 && \
			   kstrax_status.trace_syscall[KS_EXIT] == 1 && \
			   kstrax_status.trace_syscall[KS_EXECVE] == 1 && \
			   kstrax_status.trace_syscall[KS_CLONE] == 1 && \
			   kstrax_status.trace_syscall[KS_CLONE2] == 1)

#define SPECIFIED_SIGNAL (kstrax_status.trace_syscall[KS_RT_SIGACTION] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGPROCMASK] == 1 && \
			  kstrax_status.trace_syscall[KS_KILL] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGPENDING] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGQUEUEINFO] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGTIMEDWAIT] == 1 && \
			  kstrax_status.trace_syscall[KS_TKILL] == 1 && \
			  kstrax_status.trace_syscall[KS_TGKILL] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGSUSPEND] == 1 && \
			  kstrax_status.trace_syscall[KS_SIGALTSTACK] == 1 && \
			  kstrax_status.trace_syscall[KS_RT_SIGRETURN] == 1)

#define SPECIFIED_DEMO (kstrax_status.trace_syscall[KS_READ] == 1 && \
			kstrax_status.trace_syscall[KS_WRITE] == 1 && \
			kstrax_status.trace_syscall[KS_OPEN] == 1 && \
			kstrax_status.trace_syscall[KS_CLOSE] == 1 && \
			kstrax_status.trace_syscall[KS_TIMES] == 1 && \
			kstrax_status.trace_syscall[KS_GETTIMEOFDAY] == 1 && \
			kstrax_status.trace_syscall[KS_EXECVE] == 1 && \
			kstrax_status.trace_syscall[KS_CLONE] == 1)

#define IS_FILE_SYSCALL(i) \
if (i == KS_READ || i == KS_WRITE || i == KS_OPEN || \
    i == KS_LINK || i == KS_UNLINK || i == KS_EXECVE || \
    i == KS_CHDIR || i == KS_FCHDIR || i == KS_MKNOD || \
    i == KS_CHMOD || i == KS_CHOWN || i == KS_LSEEK || \
    i == KS_MOUNT || i == KS_ACCESS || i == KS_RENAME || \
    i == KS_MKDIR || i == KS_RMDIR || i == KS_ACCT || \
    i == KS_CHROOT || i == KS_SYMLINK || i == KS_READLINK || \
    i == KS_TRUNCATE || i == KS_STATFS || i == KS_STAT || \
    i == KS_LSTAT || i == KS_LCHOWN || i == KS_GETCWD || \
    i == KS_SENDFILE || i == KS_PIVOT_ROOT || i == KS_FSTAT || \
    i == KS_SETXATTR || i == KS_LSETXATTR || i == KS_GETXATTR || \
    i == KS_LGETXATTR || i == KS_LISTXATTR || i == KS_REMOVEXATTR || \
    i == KS_LREMOVEXATTR || i == KS_FADVISE64 || i == KS_OLD_STAT || \
    i == KS_OLD_LSTAT || i == KS_OLD_FSTAT || i == KS_LLISTXATTR)

#define IS_NETWORK_SYSCALL(i) \
if (i == KS_GETPMSG || i == KS_PUTPMSG || i == KS_SOCKET || \
    i == KS_BIND || i == KS_CONNECT || i == KS_LISTEN || \
    i == KS_ACCEPT || i == KS_GETSOCKNAME || i == KS_GETPEERNAME || \
    i == KS_SOCKETPAIR || i == KS_SEND || i == KS_SENDTO || \
    i == KS_RECV || i == KS_RECVFROM || i == KS_SHUTDOWN || \
    i == KS_SETSOCKOPT || i == KS_GETSOCKOPT || i == KS_SENDMSG || \
    i == KS_RECVMSG)

#define IS_IPC_SYSCALL(i) \
if (i == KS_SEMGET || i == KS_SEMOP || i == KS_SEMCTL || \
    i == KS_MSGGET || i == KS_MSGSND || i == KS_MSGRCV || \
    i == KS_MSGCTL || i == KS_SHMGET || i == KS_SHMAT || \
    i == KS_SHMDT || i == KS_SHMCTL || i == KS_SEMTIMEDOP)
	
#define IS_PROCESS_SYSCALL(i) \
if (i == KS_EXECVE || i == KS_WAIT4 || i == KS_CLONE || \
    i == KS_CLONE2 || i == KS_WAITID || i == KS_EXIT_GROUP ||	\
    i == KS_EXIT)
	

#define IS_SIGNAL_SYSCALL(i) \
if (i == KS_RT_SIGACTION || i == KS_RT_SIGPROCMASK || \
    i == KS_KILL || i == KS_RT_SIGPENDING || \
    i == KS_RT_SIGQUEUEINFO || i == KS_RT_SIGSUSPEND ||	\
    i == KS_RT_SIGTIMEDWAIT || i == KS_TKILL || i == KS_TGKILL || \
    i == KS_SIGALTSTACK || i == KS_RT_SIGRETURN)

#define IS_DEMO_SYSCALL(i) \
if (i == KS_READ || i == KS_WRITE || i == KS_OPEN || i == KS_CLOSE || \
    i == KS_EXECVE || i == KS_TIMES || i == KS_GETTIMEOFDAY || i == KS_CLONE)

#define  NOT_TRACE  -1

typedef atomic64_t kstrax_serial_t;

typedef struct sys_call_info {
	pid_t pid;
	short sys_call_number;
	long time;
	long arg_1;
	union {
		long arg_2;
		long return_value;
	};
	long arg_3;
	long arg_4;
	long arg_5;
	long arg_6;
	long serial;
	long  cpu;	
} sys_call_t;

typedef struct kbuffer_head {
	sys_call_t *buffer;
	int size;
	int w_index;
	int r_index;
	int limit_index;
	int wakeup_index;
	int wakeup_flag;
	wait_queue_head_t wq_head;
	struct tasklet_struct kst_tasklet;
} buf_head_t;

static void test_flag_spec_syscall(void);
static int kstrax_trace_each_syscall(int);

static inline void __set_basetime(sys_call_t *kst_time)
{
	struct timeval tv;
	int cpu;
	struct cpuinfo_ia64 *info;

	cpu = get_cpu();
	info= &per_cpu(cpu_info, cpu);
	
	/* get the system time (tsc & gettimeofday) */
	do_gettimeofday(&tv);
	kst_time->time = ia64_getreg(_IA64_REG_AR_ITC);
	kst_time->arg_1 = tv.tv_sec;
	kst_time->arg_2 = tv.tv_usec;
	kst_time->arg_3 = (long)(info->cyc_per_usec);	
	kst_time->pid = KS_BASETIME;
	put_cpu();
}

static inline void __kstrax_init_ipc_socketcall(trace_stat_t *kstrax_status)
{
	/* dummy function */
}

/* syscall_num is a dummy argument */
static inline void __kstrax_trace_socketcall(int syscall_num, 
					     trace_stat_t *kstrax_status)
{
	int i;
	
	if (kstrax_status->flag_spec_syscall == 1 && SPECIFIED_NETWORK == 1) {
		/* off specified syscall */
		for (i = 0; i < NR_syscalls; i++) {
			IS_NETWORK_SYSCALL(i) 
				kstrax_status->trace_syscall[i] = 0;
		}
		test_flag_spec_syscall();	
	} else {
		for (i = 0; i < NR_syscalls; i++) {
			IS_NETWORK_SYSCALL(i)
				kstrax_status->trace_syscall[i] = 1;
		}
		kstrax_status->flag_spec_syscall = 1;
	}
}

static inline void __kstrax_trace_ipc(int syscall_num,
				      trace_stat_t *kstrax_status)
{
	int i;
	
	if (kstrax_status->flag_spec_syscall == 1 && SPECIFIED_IPC == 1) {
		/* off specified syscall */
		for (i = 0; i < NR_syscalls; i++) {
			IS_IPC_SYSCALL(i) 
				kstrax_status->trace_syscall[i] = 0;
		}
		test_flag_spec_syscall();	
		return;
	} else {
		for (i = 0; i < NR_syscalls; i++) {
			IS_IPC_SYSCALL(i)
				kstrax_status->trace_syscall[i] = 1;
		}
		kstrax_status->flag_spec_syscall = 1;
	}
}

static inline int __kstrax_syscall_spec_default(int syscall_num,
						trace_stat_t *kstrax_status)
{
	printk(KERN_ERR "error(syscall_spec):bad argument\n");
	return -EINVAL;
}

static inline int __kstrax_syscall_spec_by_syscall_num(int syscall_num,
						       trace_stat_t *kstrax_status)
{
	return(kstrax_trace_each_syscall(syscall_num));
}

static inline int __check_tracing_syscall(const ctr_arg_t *args,
					  trace_stat_t *kstrax_status)
{
//	struct pt_regs *regs = ia64_task_regs(current);
	/* check tracing system call or not */
	unsigned long syscall_num = kstrax_get_syscall_num();
	if (kstrax_status->trace_syscall[syscall_num] == 0)
//	if (kstrax_status->trace_syscall[regs->r15 - 1024] == 0)
		return NOT_TRACE;
	return 0;
}

static inline void __kstrax_get_filename(const ctr_arg_t *args, 
					 buf_head_t *head, sys_call_t **buf)
{
	int i;
	int division_size, len;
	int nr_add = 0;
	char filename[256] = {'\0'};
	sys_call_t *name = NULL;
	unsigned long syscall_num = kstrax_get_syscall_num();

	/* copy_filename */
	if ((syscall_num == KS_OPEN) || (syscall_num == KS_CREAT)) {
		division_size = sizeof(sys_call_t) - 
			((unsigned long)&(*buf)->time - (unsigned long)(*buf)) -1;
		
		put_cpu();
		/* might sleep */
		len = strncpy_from_user(filename, (const char *)args->arg_1, 256);
		get_cpu();

		if (len < 0) {
			printk("Error at strncpy_from_user\n");
			return;
		}
		if (len % division_size)
			nr_add = len / division_size + 1;
		else
			nr_add = len / division_size;
		/* reload buf index*/
		*buf = &head->buffer[head->w_index];
		name = &head->buffer[(head->w_index + 1) % head->size];

		for (i = 0; i < nr_add; i++) {
			memset(name, 0, sizeof(sys_call_t));
			name->pid = KS_FILENAME;
			/* store return value(file descriptor) */
			name->sys_call_number = args->arg_6;
			strncpy((char *)&name->time,
				(const char *)&filename[i * division_size],
				division_size);

			head->w_index = (head->w_index + 1) % head->size;
			if (head->w_index == head->r_index) {
				head->r_index = (head->r_index + 1) % head->size;
			}
			name = &head->buffer[head->w_index];
		}
	}
}

static inline void __record_sys_call_information_pre(const ctr_arg_t *args,
						     sys_call_t *buf,
						     kstrax_serial_t *serial,
						     __u32 cpu)
{
	buf->pid = current->pid;
	buf->time = ia64_getreg(_IA64_REG_AR_ITC);
	buf->sys_call_number = (short)kstrax_get_syscall_num();
	buf->arg_1 = args->arg_1;
	buf->arg_2 = args->arg_2;
	buf->arg_3 = args->arg_3;
	buf->arg_4 = args->arg_4;
	buf->arg_5 = args->arg_5;
	buf->arg_6 = args->arg_6;
	buf->serial = atomic64_inc_return(serial);

	buf->cpu = cpu;
}

static inline void __record_sys_call_information_post(const ctr_arg_t *args,
						      sys_call_t *buf,
						      kstrax_serial_t *serial,
						      __u32 cpu)
{
	short syscall_num = (short)kstrax_get_syscall_num();
	buf->pid = current->pid;
	buf->time = ia64_getreg(_IA64_REG_AR_ITC);
	buf->sys_call_number = -syscall_num;
	buf->return_value = args->arg_6;
	buf->serial = atomic64_inc_return(serial);
	buf->cpu = cpu;

	if (syscall_num == 0) {
		buf->arg_1 = MAGIC_SYSCALL_ZERO;
		buf->arg_3 = MAGIC_SYSCALL_ZERO;
		buf->arg_4 = MAGIC_SYSCALL_ZERO;
		buf->arg_5 = MAGIC_SYSCALL_ZERO;
		buf->arg_6 = MAGIC_SYSCALL_ZERO;
	}
}
#endif /* __MBUFFER_ARCH__ */
