/*
 system call table stub
 Copyright (c) 2005,2007 Hitachi,Ltd.,
 Created by Satoru Moriya <satoru.moriya.br@hitachi.com>
 Updated by Masami Hiramatsu <masami.hiramatsu.pt@hitachi.com>
		 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <linux/autoconf.h>
#include <linux/linkage.h>
#include <asm/thread_info.h>
#include <asm/errno.h>
#include <asm/segment.h>
#include <asm/smp.h>
#include <asm/page.h>
	
EBX             = 0x00
ECX             = 0x04
EDX             = 0x08
ESI             = 0x0C
EDI             = 0x10
EBP             = 0x14
EAX             = 0x18
DS              = 0x1C
ES              = 0x20
ORIG_EAX        = 0x24
EIP             = 0x28
CS              = 0x2C
EFLAGS          = 0x30
OLDESP          = 0x34
OLDSS           = 0x38

ENTRY(sys_call_stub)
	popl %ebp
	
	call pre_sys_call

	movl ORIG_EAX(%esp), %eax
 	call *true_sys_call_table(,%eax,4)
	movl %eax, EAX(%esp)
	
	call post_sys_call

	movl EAX(%esp), %eax
	pushl %ebp
	GET_THREAD_INFO(%ebp)
	ret
