/*
 call table redirection
 Copyright (c) 2005,2006 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSTRAX_SYSCALL_LIST_H__
#define __KATRACE_SYSCALL_LIST_H__

enum Syscall {
	RESTART=0,
	EXIT,
	FORK,
	READ,
	WRITE,
	OPEN,               /* 5 */
	CLOSE,
	WAITPID,
	CREAT,
	LINK,
	UNLINK,             /* 10 */
	EXECVE,
	CHDIR,
	TIME,
	MKNOD,
	CHMOD,              /* 15 */
	LCHOWN16,
	OLD_BREAK,
	STAT,
	LSEEK,
	GET_PID,            /* 20 */
	MOUNT,
	OLDUMOUNT,
	SETUID16,
	GETUID16,
	STIME,              /* 25 */
	PTRACE,
	ALARM,
	FSTAT,
	PAUSE,
	UTIME,              /* 30 */
	OLD_STTY,
	OLD_GTTY,
	ACCESS,
	NICE,
	OLD_FTIME,          /* 35 */
	SYNC,
	KILL,
	RENAME,
	MKDIR,
	RMDIR,              /* 40 */
	DUP,
	PIPE,
	TIMES,
	OLD_PROF,
	BRK,                /* 45 */
	SETGID16,
	GETGID16,
	SIGNAL,
	GETEUID16,
	GETEGID16,          /* 50 */
	ACCT,
	UMOUNT,
	OLD_LOCK,
	IOCTL,
	FCNTL,              /* 55 */
	OLD_MPX,
	SETPGID,
	OLD_ULIMIT,
	OLDUNAME,
	UMASK,              /* 60 */
	CHROOT,
	USTAT,
	DUP2,
	GETPPID,
	GETPGRP,            /* 65 */
	SETSID,
	SIGACTION,
	SGETMASK,
	SSETMASK,
	SETREUID16,         /* 70 */
	SETREGID16,
	SIGSUSPEND,
	SIGPENDING,
	SETHOSTNAME,
	SETRLIMIT,          /* 75 */
	OLD_GETRLIMIT,
	GETRUSAGE,
	GETTIMEOFDAY,
	SETTIMEOFDAY,
	GETGROUPS16,        /* 80 */
	SETGROUPS16,
	OLD_SELECT,
	SYMLINK,
	LSTAT,
	READLINK,           /* 85 */
	USELIB,
	SWAPON,
	REBOOT,
	READDIR,
	OLD_MMAP,           /* 90 */
	MUNMAP,
	TRUNCATE,
	FTRUNCATE,
	FCHMOD,
	FCHOWN16,           /* 95 */
	GETPRIORITY,
	SETPRIORITY,
	OLD_PROFIL,
	STATFS,
	FSTATFS,            /* 100 */
	IOPERM,
	SOCKETCALL,
	SYSLOG,
	SETTITIMER,
	GETTITIMER,         /* 105 */
	NEWSTAT,
	NEWLSTAT,
	NEWFSTAT,
	UNAME,
	IOPL,               /* 110 */
	VHANGUP,
	OLD_IDLE,
	VM86OLD,
	WAIT4,
	SWAPOFF,            /* 115 */
	SYSINFO,
	IPC,
	FSYNC,
	SIGRETURN,
	CLONE,              /* 120 */
	SETDOMAINNAME,
	NEWUNAME,
	MODIFY_LDT,
	ADJTIMEX,
	MPROTECT,           /* 125 */
	SIGPROCMASK,
	OLD_CREATE_MODULE,
	INIT_MODULE,
	DELETE_MODULE,
	GET_KERNEL_SYMS,    /* 130 */
	QUOTACTL,
	GETPGID,
	FCHDIR,
	BDFLUSH,
	SYSFS,              /* 135 */
	PERSONALITY,
	AFS_SYSCALL,
	SETFSUID16,
	SETFSGID16,
	LLSEEK,             /* 140 */
	GETDENTS,
	SELECT,
	FLOCK,
	MSYNC,
	READV,              /* 145 */
	WRITEV,
	GETSID,
	FDATASYNC,
	SYSCTL,
	MLOCK,              /* 150 */
	MUNLOCK,
	MLOCKALL,
	MUNLOCKALL,
	SCHEC_SETPARAM,
	SCHED_GETPARAM,     /* 155 */
	SCHEC_SETSCHEDULER,
	SCHED_GETSCHEDULER,
	SCHED_YIELD,
	SCHED_GET_PRIORITY_MAX,
	SCHED_GET_PRIORITY_MIN,  /* 160 */
	SCHED_RR_GET_INTERVAL,
	NANOSLEEP,
	MREMAP,
	SETRESUID16,
	GETRESUID16,        /* 165 */
	VM86,
	OLD_SYS_QUERY_MODULE,
	POLL,
	NFSSERVCTL,
	SETRESGID16,        /* 170 */
	GETRESGID16,
	PRCTL,
	RT_SIGRETURN,
	RT_SIGACTION,
	RT_SIGPROCMASK,     /* 175 */
	RT_SIGPENDING,
	RT_SIGTIMEDWAIT,
	RT_SIGQUEUEINFO,
	RT_SIGSUSPEND,
	PREAD64,            /* 180 */
	PWRITE64,
	CHOWN16,
	GETCWD,
	CAPGET,
	CAPSET,             /* 185 */
	SIGALTSTACK,
	SENDFILE,
	STERAMS1,
	STREAMS2,
	VFORK,              /* 190 */
	GETRLIMIT,
	MMAP2,
	TRUNCATE64,
	FTRUNCATE64,
	STAT64,             /* 195 */
	LSTAT64,
	FSTAT64,
	LCHOWN,
	GETUID,
	GETGID,             /* 200 */
	GETEUID,
	GETEGID,
	SETREUID,
	SETREGID,
	GETGROUPS,          /* 205 */
	SETGROUPS,
	FCHOWN,
	SETRESUID,
	GETRESUID,
	SETRESGID,          /* 210 */
	GETRESGID,
	CHOWN,
	SETUID,
	SETGID,
	SETFSUID,           /* 215 */
	SETFSGID,
	PIVOT_ROOT,
	MINCORE,
	MADVISE,
	GETDENT64,          /* 220 */
	FCNTL64,
	TUX,
	NR_223,
	GETTID,
	READAHEAD,          /* 225 */
	SETXATTR,
	LSETXATTR,
	FSETXATTR,
	GETXATTR,
	LGETXATTR,          /* 230 */
	FGETXATTR,
	LISTXATTR,
	LLISTXATTR,
	FLISTXATTR,
	REMOVEXATTR,        /* 235 */
	LREMOVEXATTR,
	FREMOVEXATTR,
	TKILL,
	SENDFILE64,
	FUTEX,              /* 240 */
	SCHED_SETAFFINITY,
	SCHED_GETAFFINITY,
	SET_THREAD_AREA,
	GET_THREAD_AREA,
	IO_SETUP,           /* 245 */
	IO_DESTROY,
	GETEVENTS,
	SUBMIT,
	CANCEL,
	FADVISE64,          /* 250 */
	NR_251,
	EXIT_GROUP,
	LOOKUP_DCOOKIE,
	EPOLL_CREATE,
	EPOLL_CTL,          /* 255 */
	EPOLL_WAIT,
	REAMAP_FILE_PAGES,
	SET_TID_ADDRESS,
	TIMER_CREATE,
	TIMER_SETTIME,      /* 260 */
	TIMER_GETTIME,
	TIMER_GETOVERRUN,
	TIMER_DELETE,
	CLOCK_SETTIME,
	CLOCK_GETTIME,      /* 265 */
	CLOCK_GETRES,
	CLOCK_NANOSLEEP,
	STATFS64,
	FSTATFS64,
	TGKILL,             /* 270 */
	UTIMES,
	FADVISE64_64,
	SYS_VSERVER,
	MBIND,
	GET_MEMPOLICY,      /* 275 */
	SET_MEMPOLICY,
	MQ_OPEN,
	MQ_UNLINK,
	MQ_TIMEDSEND,
	MQ_TIMEDRECEIVE,    /* 280 */
	MQ_NOTIFY,
	MQ_GETSETATTR,
	KEXEC,
	WAITID,
	NR_285,
	ADD_KEY,
	REQUEST_KEY,
	KEYCTL,
	IOPRIO_SET,
	IOPRIO_GET,
	INOTIFY_INIT,
	INOTIFY_ADD_WATCH,
	INOTIFY_RM_WATCH
};

enum ipc_syscall {
	SEMOP = 1,
	SEMGET,
	SEMCTL,
	SEMTIMEDOP,
	MSGSND = 11,
	MSGRCV,
	MSGGET,
	MSGCTL,
	SHMAT = 21,
	SHMDT,
	SHMGET,
	SHMCTL
};

enum socketcall_syscall {
	SOCKET = 1,
	BIND,
	CONNECT,
	LISTEN,
	ACCEPT,
	GETSOCKNAME,
	GETPEERNAME,
	SOCKETPAIR,
	SEND,
	RECV,
	SENDTO,
	RECVFROM,
	SHUTDOWN,
	SETSOCKOPT,
	GETSOCKOPT,
	SENDMSG,
	RECVMSG
};

#endif  /* __KSTRAX_SYSCALL_LIST_H__ */ 
