/*
 kstrax ioctl header
 Copyright (c) 2006 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSTRAX_IOC_H__
#define __KSTRAX_IOC_H__

#include <linux/ioctl.h>

#define NR_TRACE_PROCESS_MAX 256  
#define TRACE_ALL     0
#define TRACE_FILE    1
#define TRACE_NETWORK 2
#define TRACE_IPC     3
#define TRACE_PROCESS 4
#define TRACE_SIGNAL  5
#define TRACE_TYPE_LIMIT   6

typedef struct kstrax_status {
	int nr_cpu;
	int trace_type;
	pid_t trace_pid[NR_TRACE_PROCESS_MAX];
	int nr_buf_entry;
} trace_stat_t;

/* magic number */
#define KSTRAX_IOC_MAGIC 'o'

#define KSTRAX_IOC_STATUS            _IOR(KSTRAX_IOC_MAGIC, 1, struct kstrax_status)
#define KSTRAX_IOC_SET_CPU           _IOW(KSTRAX_IOC_MAGIC, 2, int)
#define KSTRAX_IOC_SET_FORCE_WAKEUP  _IO(KSTRAX_IOC_MAGIC,  3)
#define KSTRAX_IOC_INIT_INDEX        _IO(KSTRAX_IOC_MAGIC,  4)
#define KSTRAX_IOC_READ_BASETIME     _IOR(KSTRAX_IOC_MAGIC, 5, int)
#define KSTRAX_IOC_SET_OWNER         _IOW(KSTRAX_IOC_MAGIC, 6, pid_t)
#define KSTRAX_IOC_CLR_OWNER         _IO(KSTRAX_IOC_MAGIC,  7)
#define KSTRAX_IOC_PID_SPEC          _IOW(KSTRAX_IOC_MAGIC, 8, pid_t)
#define KSTRAX_IOC_SYSCALL_SPEC      _IOW(KSTRAX_IOC_MAGIC, 9, char)

#endif  /* __KSTRAX_IOC_H__ */
