/*
 call table redirection
 Copyright (c) 2005 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 Updated by Masami Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __CTREDIRECT_H__
#define __CTREDIRECT_H__

#include <linux/ptrace.h>

typedef int (*call_table_t) (struct pt_regs);
typedef void (*syscall_handler_t) (const struct pt_regs);
extern call_table_t true_sys_call_table[512];

int register_ctr(syscall_handler_t, syscall_handler_t);
void unregister_ctr(void);
int kstrax_syscall_spec(int);

#ifndef SPLIT_MODULE
int init_ctr(void);
void exit_ctr(void);
#endif	/* SPLIT_MODULE */

#endif	/* __CTREDIRECT_H__ */
