#define _CRT_SECURE_NO_DEPRECATE

#include "gsc.h"

#define TEX_NUM 2
char *tex_file_name[TEX_NUM] = { "tex01.ppm", "tex02.ppm" };

int main(int argc, char *argv[])
{
  gsc_init_and_loop(&argc, argv, 0, TEX_NUM, tex_file_name);
  return 0;
}

void gsc_init_lighting(void)
{
}

void gsc_draw(void)
{
  void line(int x1, int y1, int z1, int x2, int y2, int z2, double r, double g, double b, int w);
  void tex_cube(int x, int y, int z, int len);

  line(0, 0, 0, 100, 0, 0, 1, 0, 0, 1);
  line(0, 0, 0, 0, 100, 0, 0, 1, 0, 1);
  line(0, 0, 0, 0, 0, 100, 0, 0, 1, 1);

  tex_cube(0, 0, 0, 50);
}

void line(int x1, int y1, int z1, int x2, int y2, int z2, double r, double g, double b, int w)
{
  glLineWidth(w);
  glColor3d(r, g, b);
  glBegin(GL_LINES);
  glVertex3i(x1, y1, z1);
  glVertex3i(x2, y2, z2);
  glEnd();
}

void tex_cube(int x, int y, int z, int len)
{
  int point[8][3] = {
    x, y, z, x + len, y, z, x + len, y + len, z, x, y + len, z,
    x, y, z + len, x + len, y, z + len, x + len, y + len, z + len, x, y + len, z + len
  };
  int surface[6][4] = {
    0, 4, 7, 3, 1, 2, 6, 5,
    0, 1, 5, 4, 3, 7, 6, 2,
    0, 3, 2, 1, 4, 5, 6, 7
  };
  int i, j, tex_index = 0;

  glColor3d(1, 1, 1);
  for(i = 0; i < 6; i++){
    int w = gsc_tex_width(tex_index), h = gsc_tex_height(tex_index);
    int tex_coord[4][2] = { 0, 0, w -1, 0, w -1, h -1, 0, h -1 };
    gsc_bind_texture(tex_index);
    glBegin(GL_QUADS);
    for(j = 0; j < 4; j++){
      gsc_tex_coord(tex_index, tex_coord[j][0], tex_coord[j][1] / (i /2 +1));
      glVertex3iv(point[surface[i][j]]);
    }
    glEnd();
    if(++tex_index >= TEX_NUM)
      tex_index = 0;
  }
}
