#define _CRT_SECURE_NO_DEPRECATE

#include "gsc.h"

int g_test_mode = 0, g_test_mode_max = 3;
GLfloat g_shininess = 64;

int main(int argc, char *argv[])
{
  gsc_init_and_loop(&argc, argv, 0, 0, 0);
  return 0;
}

void gsc_init_lighting(void)
{
  GLfloat pos[4] = {
    0, 0, 0, 1
  };
  GLfloat col[4] = {
    1, 1, 1, 1
  };

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glLightfv(GL_LIGHT0, GL_POSITION, pos);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, col);
  glLightfv(GL_LIGHT0, GL_SPECULAR, col);
  glLightfv(GL_LIGHT0, GL_AMBIENT, col);
}

void change_test_mode()
{
  static int save_horizontal_counter = 0, save_vertical_counter;
  int horizontal_counter = gsc_get_horizontal_counter(),
      vertical_counter = gsc_get_vertical_counter();
  int flag = 0;

  if(horizontal_counter != save_horizontal_counter){
    g_test_mode += horizontal_counter - save_horizontal_counter;
    if(g_test_mode < 0)
      g_test_mode = g_test_mode_max;
    if(g_test_mode > g_test_mode_max)
      g_test_mode = 0;
    flag = 1;
  }
  if(vertical_counter != save_vertical_counter){
    g_shininess += vertical_counter - save_vertical_counter;
    if(g_shininess <= 0)
      g_shininess = 1;
    if(g_shininess >= 128)
      g_shininess = 128;
    flag = 1;
  }
  if(flag){
    switch(g_test_mode){
    case 0:
      gsc_debug("GL_DIFFUSE %.0f", g_shininess);
      break;
    case 1:
      gsc_debug("GL_SPECULAR %.0f", g_shininess);
      break;
    case 2:
      gsc_debug("GL_AMBIENT %.0f", g_shininess);
      break;
    case 3:
      gsc_debug("GL_DIFFUSE GL_SPECULAR %.0f", g_shininess);
      break;
    }
  }
  save_horizontal_counter = horizontal_counter;
  save_vertical_counter = vertical_counter;
}

void gsc_draw(void)
{
  void material_axis(int len);
  void material_sphere(int r);

  change_test_mode();

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  material_axis(100);

  glTranslated(100, 0, 0);
  material_sphere(50, 0);

  glTranslated(-100, 100, 0);
  material_sphere(50, 1);

  glTranslated(-100, -100, 0);
  material_sphere(50, 2);
}

void material_axis(int len)
{
  GLfloat col[4][4] = {
    1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1
  };
  int pos[3][3] = {
    len, 0, 0, 0, len, 0, 0, 0, len
  };
  int i;

  glLineWidth(3);
  for(i = 0; i < 3; i++){
    glMaterialfv(GL_FRONT, GL_DIFFUSE, col[3]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, col[3]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, col[3]);
    glMaterialfv(GL_FRONT, GL_EMISSION, col[i]);
    glMaterialf(GL_FRONT, GL_SHININESS, 0);
    glBegin(GL_LINES);
    glVertex3i(0, 0, 0);
    glVertex3iv(pos[i]);
    glEnd();
  }
}

void material_sphere(int radius, int color)
{
  GLfloat col[4][4] = {
    1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1
  };

  if(color < 0 || color > 2)
    color = 0;

  switch(g_test_mode){
  case 0:
    glMaterialfv(GL_FRONT, GL_DIFFUSE, col[color]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, col[3]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, col[3]);
    glMaterialfv(GL_FRONT, GL_EMISSION, col[3]);
    break;
  case 1:
    glMaterialfv(GL_FRONT, GL_DIFFUSE, col[3]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, col[color]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, col[3]);
    glMaterialfv(GL_FRONT, GL_EMISSION, col[3]);
    break;
  case 2:
    glMaterialfv(GL_FRONT, GL_DIFFUSE, col[3]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, col[3]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, col[color]);
    glMaterialfv(GL_FRONT, GL_EMISSION, col[3]);
    break;
  case 3:
    glMaterialfv(GL_FRONT, GL_DIFFUSE, col[color]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, col[color]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, col[3]);
    glMaterialfv(GL_FRONT, GL_EMISSION, col[3]);
    break;
  }
  glMaterialf(GL_FRONT, GL_SHININESS, g_shininess);
  glutSolidSphere(radius, 30, 30);
}
