#define _CRT_SECURE_NO_DEPRECATE

#include "gsc.h"

int g_test_mode = 0, g_test_mode_max = 3;
GLfloat g_distance = 100, g_distance_diff = 10;

int main(int argc, char *argv[])
{
  gsc_init_and_loop(&argc, argv, 0, 0, 0);
  return 0;
}

void gsc_init_lighting(void)
{
  GLenum name[3] = {
    GL_LIGHT0, GL_LIGHT1, GL_LIGHT2
  };
  GLfloat pos[3][4] = {
    g_distance, 0, 0, 1, 0, g_distance, 0, 1, 0, 0, g_distance, 1
  };
  GLfloat col[4][4] = {
    1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1,
    0, 0, 0, 1
  };
  int i;

  glEnable(GL_LIGHTING);
  for(i = 0; i < 3; i++){
    glEnable(name[i]);
    glLightfv(name[i], GL_POSITION, pos[i]);
    switch(g_test_mode){
    case 0:
      glLightfv(name[i], GL_DIFFUSE, col[i]);
      glLightfv(name[i], GL_SPECULAR, col[3]);
      glLightfv(name[i], GL_AMBIENT, col[3]);
      gsc_debug("GL_DIFFUSE %.0f", g_distance);
      break;
    case 1:
      glLightfv(name[i], GL_DIFFUSE, col[3]);
      glLightfv(name[i], GL_SPECULAR, col[i]);
      glLightfv(name[i], GL_AMBIENT, col[3]);
      gsc_debug("GL_SPECULAR %.0f", g_distance);
      break;
    case 2:
      glLightfv(name[i], GL_DIFFUSE, col[3]);
      glLightfv(name[i], GL_SPECULAR, col[3]);
      glLightfv(name[i], GL_AMBIENT, col[i]);
      gsc_debug("GL_AMBIENT %.0f", g_distance);
      break;
    case 3:
      glLightfv(name[i], GL_DIFFUSE, col[i]);
      glLightfv(name[i], GL_SPECULAR, col[i]);
      glLightfv(name[i], GL_AMBIENT, col[3]);
      gsc_debug("GL_DIFFUSE GL_SPECULAR %.0f", g_distance);
      break;
    }
  }
}

void change_test_mode()
{
  static int save_horizontal_counter = 0, save_vertical_counter;
  int horizontal_counter = gsc_get_horizontal_counter(),
      vertical_counter = gsc_get_vertical_counter();
  int flag = 0;

  if(horizontal_counter != save_horizontal_counter){
    g_test_mode += horizontal_counter - save_horizontal_counter;
    if(g_test_mode < 0)
      g_test_mode = g_test_mode_max;
    if(g_test_mode > g_test_mode_max)
      g_test_mode = 0;
    flag = 1;
  }
  if(vertical_counter != save_vertical_counter){
    g_distance += g_distance_diff * (save_vertical_counter - vertical_counter);
    if(g_distance < 0)
      g_distance = g_distance_diff;
    flag = 1;
  }
  if(flag)
    gsc_debug("g_test_mode = %d , g_distance = %.0f , please type Home key",
              g_test_mode, g_distance);
  save_horizontal_counter = horizontal_counter;
  save_vertical_counter = vertical_counter;
}

void gsc_draw(void)
{
  void material_axis(int len);
  void material_sphere(int r);

  change_test_mode();

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  material_axis(100);

  material_sphere(50);
}

void material_axis(int len)
{
  GLfloat col[4][4] = {
    1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1
  };
  int pos[3][3] = {
    len, 0, 0, 0, len, 0, 0, 0, len
  };
  int i;

  glLineWidth(3);
  for(i = 0; i < 3; i++){
    glMaterialfv(GL_FRONT, GL_DIFFUSE, col[3]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, col[3]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, col[3]);
    glMaterialfv(GL_FRONT, GL_EMISSION, col[i]);
    glMaterialf(GL_FRONT, GL_SHININESS, 0);
    glBegin(GL_LINES);
    glVertex3i(0, 0, 0);
    glVertex3iv(pos[i]);
    glEnd();
  }
}

void material_sphere(int r)
{
  GLfloat col[2][4] = {
    1, 1, 1, 1, 0, 0, 0, 1
  };

  glMaterialfv(GL_FRONT, GL_DIFFUSE, col[0]);
  glMaterialfv(GL_FRONT, GL_SPECULAR, col[0]);
  glMaterialfv(GL_FRONT, GL_AMBIENT, col[0]);
  glMaterialfv(GL_FRONT, GL_EMISSION, col[1]);
  glMaterialf(GL_FRONT, GL_SHININESS, 30);

  glutSolidSphere(r, 30, 30);
}
