#define _CRT_SECURE_NO_DEPRECATE

#include "gsc.h"

int g_test_mode = 0, g_test_mode_max = 2;

int main(int argc, char *argv[])
{
  gsc_init_and_loop(&argc, argv, 0, 0, 0);
  return 0;
}

void gsc_init_lighting(void)
{
  GLenum name[3] = {
    GL_LIGHT0, GL_LIGHT1, GL_LIGHT2
  };
  GLfloat pos[3][4] = {
    300, 0, 0, 1, 0, 300, 0, 1, 0, 0, 300, 1
  };
  GLfloat col[4][4] = {
    1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1,
    0, 0, 0, 1
  };
  GLfloat dir[3][3] = {
    -1, 0, 0, 0, -1, 0, 0, 0, -1
  };
  int i;

  glEnable(GL_LIGHTING);
  for(i = 0; i < 3; i++){
    glEnable(name[i]);
    glLightfv(name[i], GL_POSITION, pos[i]);
    switch(g_test_mode){
    case 0:
      glLightfv(name[i], GL_DIFFUSE, col[i]);
      glLightfv(name[i], GL_SPECULAR, col[3]);
      glLightfv(name[i], GL_AMBIENT, col[3]);
      gsc_debug("GL_DIFFUSE 1 1 1");
      break;
    case 1:
      glLightfv(name[i], GL_DIFFUSE, col[3]);
      glLightfv(name[i], GL_SPECULAR, col[i]);
      glLightfv(name[i], GL_AMBIENT, col[3]);
      gsc_debug("GL_SPECULAR 1 1 1");
      break;
    case 2:
      glLightfv(name[i], GL_DIFFUSE, col[3]);
      glLightfv(name[i], GL_SPECULAR, col[3]);
      glLightfv(name[i], GL_AMBIENT, col[i]);
      gsc_debug("GL_AMBIENT 1 1 1");
      break;
    }
  }
}

void change_test_mode()
{
  static int save_counter = 0;
  int counter = gsc_get_horizontal_counter();

  if(counter != save_counter){
    g_test_mode += counter - save_counter;
    if(g_test_mode < 0)
      g_test_mode = g_test_mode_max;
    if(g_test_mode > g_test_mode_max)
      g_test_mode = 0;
    gsc_debug("g_test_mode = %d please type Home key", g_test_mode);
  }
  save_counter = counter;
}

void gsc_draw(void)
{
  void material_axis(int len);
  void material_cube(int x, int y, int z, int len);

  change_test_mode();

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  material_axis(100);

  glTranslated(-50, -50, -50);
  material_cube(0, 0, 0, 100);
}

void material_axis(int len)
{
  GLfloat col[4][4] = {
    1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1
  };
  int pos[3][3] = {
    len, 0, 0, 0, len, 0, 0, 0, len
  };
  int i;

  glLineWidth(3);
  for(i = 0; i < 3; i++){
    glMaterialfv(GL_FRONT, GL_DIFFUSE, col[3]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, col[3]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, col[3]);
    glMaterialfv(GL_FRONT, GL_EMISSION, col[i]);
    glMaterialf(GL_FRONT, GL_SHININESS, 0);
    glBegin(GL_LINES);
    glVertex3i(0, 0, 0);
    glVertex3iv(pos[i]);
    glEnd();
  }
}

void material_cube(int x, int y, int z, int len)
{
  int point[8][3] = {
    x, y, z, x + len, y, z, x + len, y + len, z, x, y + len, z,
    x, y, z + len, x + len, y, z + len, x + len, y + len, z + len, x, y + len, z + len
  };
  int surface[6][4] = {
    0, 4, 7, 3, 1, 2, 6, 5,
    0, 1, 5, 4, 3, 7, 6, 2,
    0, 3, 2, 1, 4, 5, 6, 7
  };
  int normal[6][3] = {
    -1, 0, 0, 1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, -1, 0, 0, 1
  };
  GLfloat col[2][4] = {
    1, 1, 1, 1, 0, 0, 0, 1
  };
  int i, j;

  for(i = 0; i < 6; i++){
    glMaterialfv(GL_FRONT, GL_DIFFUSE, col[0]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, col[0]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, col[0]);
    glMaterialfv(GL_FRONT, GL_EMISSION, col[1]);
    glMaterialf(GL_FRONT, GL_SHININESS, 10);

    glNormal3iv(normal[i]);
    glBegin(GL_QUADS);
    for(j = 0; j < 4; j++){
      glVertex3iv(point[surface[i][j]]);
    }
    glEnd();
  }
}
