#define _CRT_SECURE_NO_DEPRECATE

#include "gsc.h"

void gsc_init_lighting(void)
{
}

void color(double r, double g, double b)
{
  glColor3d(r, g, b);
}

void point(int x, int y)
{
  glBegin(GL_POINTS);
  glVertex2i(x, y);
  glEnd();
}

void line(int sx, int sy, int ex, int ey)
{
  glBegin(GL_LINES);
  glVertex2i(sx, sy);
  glVertex2i(ex, ey);
  glEnd();
}

void rect(int x, int y, int w, int h)
{
  glBegin(GL_POLYGON);
  glVertex2i(x, y);
  glVertex2i(x + w, y);
  glVertex2i(x + w, y + h);
  glVertex2i(x, y + h);
  glEnd();
}

void cube(int x, int y, int z, int len)
{
  int point[8][3] = {
    x, y, z, x + len, y, z, x + len, y + len, z, x, y + len, z,
    x, y, z + len, x + len, y, z + len, x + len, y + len, z + len, x, y + len, z + len
  };
  int surface[6][4] = {
    0, 4, 7, 3, 1, 2, 6, 5,
    0, 1, 5, 4, 3, 7, 6, 2,
    0, 3, 2, 1, 4, 5, 6, 7
  };
  int i, j;

  glBegin(GL_QUADS);
  for(i = 0; i < 6; i++){
    switch(i){
    case 0:
      glColor3d(1, 0, 0);
      break;
    case 2:
      glColor3d(0, 1, 0);
      break;
    case 4:
      glColor3d(0, 0, 1);
      break;
    }
    for(j = 0; j < 4; j++){
      glVertex3iv(point[surface[i][j]]);
    }
  }
  glEnd();
}

void pi(int a)
{
  printf("%d\n", a);
}

void pf(float a)
{
  printf("%f\n", a);
}
