/***************************************************************************
                          viewTabs.h  -  description
                             -------------------
    begin                :   2 21 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef VIEWTABS_H
#define VIEWTABS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qlcdnumber.h>
#include <qdatetime.h>

// include files for KDE

// forward declaration

// forward declaration
class CronTbl;
class UserTbl;
class AnacTbl;
class AtTbl;
#ifndef CRON_DILLON
class LogTbl;
#endif
class ClockView;
class UserComboBox;
class FileComboBox;
class VarListView;
class IconPushButton;
class FrameLabel;

class QPushButton;
class QFrame;
class QLineEdit;
class QTextEdit;
class QSpinBox;
class QRadioButton;
class QTextView;

/**
  * Time Display Label class
  */
class TimeLabel : public QLCDNumber
{

  public:
    /** Constructor */
    TimeLabel(QWidget *p);
    /** Destructor */
    ~TimeLabel() {};

    /** Clear Display */
    inline void clrTime() { display( "" ); }
    /** Display DateTime Format */
    inline void dspTime( QDateTime* t ) { display( t->toString( "yyyy-MM-dd hh:mm:ss" ) ); }
    /** Display Rest Time */
    void dspTime( int sec );
};

/**
  * Clock Display Tab
  */
class ClockWgt : public QWidget
{
  public:
    /** Constructor */
    ClockWgt();
    /** Destructor */
    ~ClockWgt() {};

    /** Display 'cron' time */
    void dspClock( CronTbl *cr, QDateTime* t );
    /** Display 'anacron' time */
    void dspClock( AnacTbl *an, QDateTime* t );
    /** Display 'at' & Log time */
    void dspClock( QDateTime* t );
    /** Clear time */
    void clrClock( );
    /** Display Current Time */
    void dspCurTime();

    /** Clock View */
    ClockView *clockView;
    /** Currnet Time Label */
    TimeLabel *lblCur;
    /** Execute Next Time Label */
    TimeLabel *lblNext;
    /** Rest Time Label */
    TimeLabel *lblRest;
    /** Execute Next Time */
    QDateTime *nextTime;

};


/**
  * Detail Display Tab
  */
class DetailWgt : public QWidget
{
  public:
    /** Constructor */
    DetailWgt();
    /** Destructor */
    ~DetailWgt() {};

    /** Display 'cron' detail */
    void dspText( CronTbl *cr, const QDateTime& t);
    /** Display 'anacron' detail */
    void dspText( AnacTbl *an, const QDateTime& t);
    /** Display 'at' detail */
    void dspText( AtTbl *at );
#ifndef CRON_DILLON
    /** Display Log detail */
    void dspText( LogTbl *log );
#endif
    
    /** Detail Text View */
    QTextView *textView;

    QString cronText;       // 'cron' detail template
    QString anacText;       // 'anacron' detail template
    QString atText;         // 'at' detail template
    QString logCronText;    // Log ('cron') detail template
    QString logAnacText;    // Log ('anacron') detail template
    QString logAtText;      // Log 'at' Detail Template
};


/**
  * Edit Tab Common Class
  */
class EditWgt : public QWidget
{
  public:
    /** Constructor */
    EditWgt();
    /** Destructor */
    ~EditWgt() {};

    /** Set button Enable/Disable */
    void setEnable( bool bWrite, bool bMod, bool bNew, bool bExe );

    /** Frame */
    QFrame *Frame;
    /** Modify button */
    QPushButton *modBtn;
    /** Create button */
    QPushButton *creBtn;
    /** Delete button */
    QPushButton *delBtn;
    /** Execute button */
    QPushButton *exeBtn;
};


/**
  * 'cron' Edit Tab
  */
class CronEditWgt : public EditWgt
{
  public:
    /** Constructor */
    CronEditWgt();
    /** Destructor */
    ~CronEditWgt() {};

    /** Initialize display */
    void iniEdit(CronTbl *cr);
    void setButton(const CronTbl& chk);

    QLineEdit       *timLed;     // Time Edit
    IconPushButton  *timBtn;     // Time Dialog Button
    UserComboBox    *usrCmb;     // User Select
#ifndef CRON_DILLON
    FileComboBox    *filCmb;     // File Select
#endif
    VarListView     *varLvw;     // Variable Edit
    IconPushButton  *varBtn;     // Variable Dialog Button
    QLineEdit       *cmdLed;     // Command Edit
    QTextEdit       *cmtTed;     // Comment Edit

    /** Editing Data */
    CronTbl    *editCron;

};

/**
  * 'anacron' Edit Tab
  */
class AnacEditWgt : public EditWgt
{

  public:
    /** Constructor */
    AnacEditWgt();
    /** Destructor */
    ~AnacEditWgt() {};

    /** Initialize display */
    void iniEdit(AnacTbl *an);
    /** Set modify button */
    void setButton( const AnacTbl& an );

    QPushButton     *filBtn;      // File Edit Button
    QSpinBox        *prdSpb;      // Period
    QSpinBox        *dlySpb;      // Delay
    QLineEdit       *idtLed;      // Identifier
    VarListView     *varLvw;      // Variable Edit
    IconPushButton  *varBtn;      // Variable Dialog Button
    QLineEdit       *cmdLed;      // Command Edit
    QTextEdit       *cmtTed;      // Comment Edit

    /** Editing data */
    AnacTbl     *editAnac;

};

/**
  * 'at' Edit Tab
  */
class AtEditWgt : public EditWgt
{

  public:
    /** Constructor */
    AtEditWgt();
    /** Destructor */
    ~AtEditWgt() {};

    /** Initialize display */
    void iniEdit(AtTbl *at);
    /** Set modify button */
    void setButton(const AtTbl& at);

    FrameLabel      *usrLbl;    // User Select
    QLineEdit       *timLed;    // Time Edit
    IconPushButton  *timBtn;    // Time Dialog Button
    QLineEdit       *queLed;    // Queue Identifier
    QRadioButton    *monRdb;    // Mail ON/
    QRadioButton    *mofRdb;    // Mail /OFF
    QTextEdit       *cmdTed;    // Command Edit
    QPushButton     *filBtn;    // File Edit Button

    /** Editing data */
    AtTbl    *editAt;

};


#endif // VIEWTABS_H
