/***************************************************************************
                          timeDlg.h  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef TIMEDLG_H
#define TIMEDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qlabel.h>
#include <qpushbutton.h>
#include <qdatetime.h>

// include files for KDE
#include <kdialog.h>

// forward declaration
class CronBit;
class QButtonGroup;
class QString;
class FrameLabel;
class QDateTimeEdit;
class QLabel;
class QPainter;

/**
  * Numeric Button Class
  */
class TimeButton : public QPushButton
{
  public:
    /** Constructor */
    TimeButton( QWidget* p, const QString& l );
    TimeButton( QWidget* p, int i );
  private:
    // Change Toggled Color
    void drawButtonLabel( QPainter *p );
};


/**
  * Cron Time Edit Dialog
  */
class CronTimeDlg : public KDialog
{
  Q_OBJECT
  public:
    /** Constructor */
    CronTimeDlg( const QString& tstr );
    /** Destructor */
    ~CronTimeDlg();

  public:
    /** return Edited 'cron' Time */
    inline QString getTime() { return ((QLabel *)timeLbl)->text(); }

  private:
    /** reset Simple Button(Hourly,.. ) */
    void iniSimple();
    
    /** Initialize All Buttons */
    void iniButton();

    /** 'cron' Time Cronvert Class */
    CronBit* cronBit;
    /** Button Groups */
    QButtonGroup* minBgp;
    QButtonGroup* hourBgp;
    QButtonGroup* dayBgp;
    QButtonGroup* monBgp;
    QButtonGroup* weekBgp;
    QButtonGroup* simpleBgp;
    FrameLabel*    timeLbl;

  protected slots:
    /** Minute Button Group Action */
    void slotMinuteButtons( int id );
    /** Hour Button Group Action */
    void slotHourButtons( int id );
    /** Day Button Group Action */
    void slotDayButtons( int id );
    /** Month Button Group Action */
    void slotMonthButtons( int id );
    /** Week Button Group Action */
    void slotWeekButtons( int id );
    /** Simple Button Group Action */
    void slotSimpleButtons( int id );

};

/**
  * At Time Edit Dialog
  */
class AtTimeDlg : public KDialog
{
  Q_OBJECT
  public:
    /** Constructor */
    AtTimeDlg(const QDateTime& t);
    /** Destructor */
    ~AtTimeDlg();

    /** return Edited 'at' Time */
    inline QString getTime() { return setDt.toString( "yyyy-MM-dd hh:mm" ); }
    inline QDateTime getTimeDT() { return setDt; }

  private:
    /** Initialize Month Buttons */
    void iniCalend();
    /** Initialize All Buttons */
    void iniButton();

    /** Editing DateTime */
    QDateTime     setDt;
    /** DateTimeEdit */
    QDateTimeEdit* setDte;
    /** Day Starting Position of Calendar */
    int startDayPos;
    /** Setting Start Year */
    int startYear;

    /** Button Groups */
    QButtonGroup* yearBgp;
    QButtonGroup* monBgp;
    QButtonGroup* dayBgp;
    QButtonGroup* hourBgp;
    QButtonGroup* minBgp;

  protected slots:
    /** Year Button Group Action */
    void slotYearButtons( int id );
    /** Month Button Group Action */
    void slotMonthButtons( int id );
    /** Day Button Group Action */
    void slotDayButtons( int id );
    /** Hour Button Group Action */
    void slotHourButtons( int id );
    /** Minute Button Group Action */
    void slotMinuteButtons( int id );
    /** DateTimeEdit Data Changed */
    void slotChangeDateTime( const QDateTime& dt );
};

#endif // TIMEDLG_H

