/***************************************************************************
                          commonWgt.cpp  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>

// include files for Qt
#include <qdatetime.h>
#include <qlistview.h>
#include <qfile.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qlabel.h>

// include files for KDE
#include <klocale.h>
#include <kdialogbase.h>

// application specific includes
#include "system.h"
#include "option.h"
#include "docTables.h"
#include "commonWgt.h"

extern Option* g_Option;

/////////////////////////////////////////////////////////////////////////////
// CButtonGroup - QButtonGroup Common Class

//
// Constructor
CButtonGroup::CButtonGroup( const QString& str, QWidget* p ) :
  QButtonGroup( str, p )
{
    setColumnLayout( 0, Qt::Vertical );
    layout()->setSpacing( KDialogBase::spacingHint() );
    layout()->setMargin( KDialogBase::marginHint() );
}

/////////////////////////////////////////////////////////////////////////////
// CGroupBox - QGroupBox Common Class

//
// Constructor
CGroupBox::CGroupBox( const QString& str, QWidget* p ) :
  QGroupBox( str, p )
{
    setColumnLayout( 0, Qt::Vertical );
    layout()->setSpacing( KDialogBase::spacingHint() );
    layout()->setMargin( KDialogBase::marginHint() );
}


/////////////////////////////////////////////////////////////////////////////
// FrameLabel - Label with Frame

//
// Constructor
FrameLabel::FrameLabel( const QString& str, QWidget* p )
  : QLabel( str, p )
{
  setFrameShape( QFrame::StyledPanel );
  setFrameShadow( QFrame::Sunken );

}

/////////////////////////////////////////////////////////////////////////////
// IconPushButton - Icon Push Button

//
// Constructor
IconPushButton::IconPushButton( const QString& iname, QWidget* p ) :
  QPushButton( p )
{
  // set pixmap from kde application directory
  setPixmap( IconFile( iname ) );
}

/////////////////////////////////////////////////////////////////////////////
// UserComboBox - User Select Combo Box

//
// Constructor
UserComboBox::UserComboBox( QWidget *w ) : QComboBox( w )
{
}

//
// Initialize List
bool UserComboBox::setUser( UserSel u )
{

  clear();

  if ( u == Current ){
    // Current User Only
    insertItem( System::uName() );
  }else{
    // Get Users String List
    QStringList sl;
    if ( u == All ){
      // All Users
      sl = System::allUsers();
    }else if ( u == AllowCron ){
      // 'cron' Allow Users
      sl = System::cronUsers();
    }else if ( u == AllowAt ){
      // 'at' Allow Users
      sl = System::atUsers();
    }
    // Insert
    insertStringList( sl );
  }
  
  return true;
}

/////////////////////////////////////////////////////////////////////////////
// File Select Combo Box ('cron')

#ifndef CRON_DILLON
//
// Constructor
FileComboBox::FileComboBox( QWidget *w ) : QComboBox( w )
{
}


//
// Initialize List
void FileComboBox::iniFile( const QString& user, CRONTYPE ctype )
{

  clear();
  bool f = g_Option->useSyscron && System::isCronWritable();
  if ( ctype == CRON_ETC || f ){
    insertItem( "System (" + g_Option->cronFileSys + ")");
  }
  if ( ctype == CRON_USER || f ){
    insertItem( "User (" + g_Option->cronPathSpool + "/" + user + ")");
  }
  if ( ctype == CRON_ETC || !f ){
    setCurrentItem( 0 );
  }else{
    setCurrentItem( 1 );
  }
}

void FileComboBox::setCurrent( CRONTYPE ctype )
{
  if ( g_Option->useSyscron && System::isCronWritable() ){
    setCurrentItem( 0 );
  }else{
    if ( ctype == CRON_ETC ){
      setCurrentItem( 0 );
    }else{
      setCurrentItem( 1 );
    }
  }

}
#endif


/////////////////////////////////////////////////////////////////////////////
// VarListViewItem - Variable List View Item

//
// Constructor
VarListViewItem::VarListViewItem( QListView *p, const QString& n, const QString& v, const QString& c) :
      QListViewItem( p ), name(n), value(v), cmnt(c)
{
    setText( 0, n );    // name
    setText( 1, v );    // value
};

/////////////////////////////////////////////////////////////////////////////
// VarListView - Variable List View

//
// Constructor
VarListView::VarListView( QWidget *w ) : QListView( w )
{
  setAllColumnsShowFocus( 1 );
//  setMinimumSize( QSize( 0, 30 ) );
  addColumn( i18n( "Name" ) );
  addColumn( i18n( "Value" ) );
}

//
// Initialize List from Variable Table
void VarListView::setVar( QPtrList<VarTbl> *var )
{

  clear();
  for( VarTbl *v=var->first(); v; v=var->next() ){
    new VarListViewItem( this, v->Name, v->Val, v->Cmnt );
  }
}
