/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.korenani;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jp.osdn.i18n.I18n;
import jp.osdn.i18n.L10nComponent;
import jp.osdn.i18n.LocaleListener;
import jp.osdn.korenani.LocaleListenerImpl;
import jp.osdn.korenani.StockIcons;

public class LanguageMenu
extends JMenu
implements L10nComponent {
    private HashMap<String, JRadioButtonMenuItem> itemsMap = new HashMap();
    private String langCode;
    private final LocaleListener localeListener;

    public LanguageMenu() {
        this.addItems();
        this.setIcon(LanguageMenu.languageIcon(I18n.gtxt("DETECTED_LANGUAGE")));
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                String string = I18n.gtxt("DETECTED_LANGUAGE");
                LanguageMenu.this.langCode = string;
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                I18n.reset(LanguageMenu.this.langCode);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
                I18n.reset(LanguageMenu.this.langCode);
            }
        });
        String string = I18n.gtxt("DETECTED_LANGUAGE");
        JRadioButtonMenuItem jRadioButtonMenuItem = this.itemsMap.get(string);
        this.setText(I18n.gtxt("Language"));
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
    }

    private void addItems() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.addItem("en", "English", buttonGroup);
        this.addItem("fr", "Fran\u00e7ais", buttonGroup);
        this.addItem("ja", "\u65e5\u672c\u8a9e", buttonGroup);
    }

    private void addItem(final String string, String string2, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
        this.itemsMap.put(string, jRadioButtonMenuItem);
        jRadioButtonMenuItem.setAction(new AbstractAction(string2, LanguageMenu.languageIcon(string)){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                I18n.reset(string);
            }
        });
        jRadioButtonMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                I18n.reset(string);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                I18n.reset(LanguageMenu.this.langCode);
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        this.add(jRadioButtonMenuItem);
    }

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setText(I18n.gtxt("Language"));
        this.setIcon(LanguageMenu.languageIcon(string));
        JRadioButtonMenuItem jRadioButtonMenuItem = this.itemsMap.get(string);
        if (jRadioButtonMenuItem != null) {
            jRadioButtonMenuItem.setSelected(true);
        }
        if (this.isSelected()) {
            return;
        }
    }

    public static Icon languageIcon(String string) {
        if ("en".equals(string)) {
            return StockIcons.ICON_FLAG_EN;
        }
        if ("fr".equals(string)) {
            return StockIcons.ICON_FLAG_FR;
        }
        if ("ja".equals(string)) {
            return StockIcons.ICON_FLAG_JA;
        }
        return StockIcons.ICON_GO_HOME;
    }
}

