/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.korenani;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jp.osdn.i18n.I18n;
import jp.osdn.korenani.CheckUpdateDialog;
import jp.osdn.korenani.NewVersionFoundDialog;

public class CheckUpdateAction
extends AbstractAction {
    private Action openUpdateSiteAction;
    private JFrame frame;

    public CheckUpdateAction(JFrame jFrame, Action action) {
        this.frame = jFrame;
        this.openUpdateSiteAction = action;
        this.performSilentCheck();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CheckUpdateDialog checkUpdateDialog = new CheckUpdateDialog(this.frame, this);
        checkUpdateDialog.setVisible(true);
        int n = checkUpdateDialog.getResult();
        if (n == 0) {
            JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>" + I18n.gtxt("This version of Korenani is up-to-date.") + "</tr>" + "</html>", "Korenani", -1);
        } else if (n == 1) {
            this.openUpdateSiteAction.setEnabled(true);
            NewVersionFoundDialog newVersionFoundDialog = new NewVersionFoundDialog(this.frame);
            newVersionFoundDialog.setVisible(true);
        } else if (n == -1) {
            JOptionPane.showMessageDialog(this.frame, "<html><table border=\"0\"><tr>" + I18n.gtxt("Unable to retrieve update information.<br/><br/>Please check on the following website<br/>if a new version of Korenani is available:<br/><br/>") + "http://sourceforge.net/projects/korenani/files/korenani" + "</tr>" + "</html>", "Korenani", 2);
        }
    }

    public void performSilentCheck() {
        CheckUpdateDialog checkUpdateDialog = new CheckUpdateDialog(this.frame, this);
        checkUpdateDialog.setVisible(false);
    }

    void notifyNewVersionFound() {
        this.openUpdateSiteAction.setEnabled(true);
    }
}

