/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.korenani;

import com.polarcloud.rikaichan.RcxData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import jp.osdn.korenani.AppConfig;
import jp.osdn.korenani.MenuBar;

public class AppFrame
extends JFrame {
    JTextPane textPane;
    AbstractDocument doc;
    static final int MAX_CHARACTERS = 300;
    JTextArea translationsArea;
    String newline = "\n";
    HashMap<Object, Action> actions;
    private JSplitPane splitPane;
    private JScrollPane scrollPaneForTranslations;
    MyWindowFocusListener myWindowFocusListener = new MyWindowFocusListener();

    public AppFrame() {
        super("Korenani 0.1");
        if (null == AppConfig.INSTANCE.getDictionary()) {
            throw new RuntimeException("Dictionary not found!");
        }
        this.textPane = new JTextPane();
        this.textPane.setCaretPosition(0);
        this.textPane.setMargin(new Insets(5, 5, 5, 5));
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        if (styledDocument instanceof AbstractDocument) {
            this.doc = (AbstractDocument)((Object)styledDocument);
        } else {
            System.err.println("Text pane's document isn't an AbstractDocument!");
            System.exit(-1);
        }
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        this.translationsArea = new JTextArea(10, 100);
        this.translationsArea.setEditable(false);
        this.translationsArea.setFont(new Font("SansSerif", 0, 16));
        this.scrollPaneForTranslations = new JScrollPane(this.translationsArea);
        this.splitPane = new JSplitPane(0, jScrollPane, this.scrollPaneForTranslations);
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        CaretListenerLabel caretListenerLabel = new CaretListenerLabel(".");
        caretListenerLabel.displaySelectionInfo(0, 0);
        jPanel.add(caretListenerLabel);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)jPanel, "Last");
        this.actions = this.createActionTable(this.textPane);
        MenuBar menuBar = new MenuBar(this);
        this.setJMenuBar(menuBar);
        this.addBindings();
        this.initDocument();
        this.textPane.setCaretPosition(0);
        this.textPane.addCaretListener(caretListenerLabel);
        this.doc.addDocumentListener(new MyDocumentListener());
        this.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.getToolkit().getScreenSize().height / 2));
        try {
            RcxData.deinflectInit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addWindowFocusListener(this.myWindowFocusListener);
    }

    protected void addBindings() {
        InputMap inputMap = this.textPane.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(66, 2);
        inputMap.put(keyStroke, "caret-backward");
        keyStroke = KeyStroke.getKeyStroke(70, 2);
        inputMap.put(keyStroke, "caret-forward");
        keyStroke = KeyStroke.getKeyStroke(80, 2);
        inputMap.put(keyStroke, "caret-up");
        keyStroke = KeyStroke.getKeyStroke(78, 2);
        inputMap.put(keyStroke, "caret-down");
    }

    protected JMenu createEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.addSeparator();
        jMenu.add(this.getActionByName("cut-to-clipboard"));
        jMenu.add(this.getActionByName("copy-to-clipboard"));
        jMenu.add(this.getActionByName("paste-from-clipboard"));
        jMenu.addSeparator();
        jMenu.add(this.getActionByName("select-all"));
        return jMenu;
    }

    protected void initDocument() {
        String[] stringArray = new String[]{AppFrame.getClipboardText()};
        SimpleAttributeSet[] simpleAttributeSetArray = this.initAttributes(stringArray.length);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this.doc.insertString(0, stringArray[i] + this.newline, simpleAttributeSetArray[i]);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Couldn't insert initial text.");
        }
    }

    protected SimpleAttributeSet[] initAttributes(int n) {
        SimpleAttributeSet[] simpleAttributeSetArray = new SimpleAttributeSet[n];
        simpleAttributeSetArray[0] = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSetArray[0], "SansSerif");
        return simpleAttributeSetArray;
    }

    private HashMap<Object, Action> createActionTable(JTextComponent jTextComponent) {
        HashMap<Object, Action> hashMap = new HashMap<Object, Action>();
        Action[] actionArray = jTextComponent.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            hashMap.put(action.getValue("Name"), action);
        }
        return hashMap;
    }

    private Action getActionByName(String string) {
        return this.actions.get(string);
    }

    public void positionSplitPane() {
        this.splitPane.setDividerLocation(0.33);
    }

    public static String getClipboardText() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                System.out.println(string);
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "(no text found in clipboard)";
    }

    private class MyWindowFocusListener
    implements WindowFocusListener {
        private MyWindowFocusListener() {
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            String string = AppFrame.getClipboardText();
            try {
                AppFrame.this.doc.remove(0, AppFrame.this.doc.getLength());
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontFamily(simpleAttributeSet, "SansSerif");
                StyleConstants.setFontSize(simpleAttributeSet, 20);
                AppFrame.this.doc.insertString(0, string + AppFrame.this.newline, simpleAttributeSet);
                AppFrame.this.textPane.setCaretPosition(0);
                AppFrame.this.textPane.requestFocusInWindow();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
        }
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.displayEditInfo(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.displayEditInfo(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.displayEditInfo(documentEvent);
        }

        private void displayEditInfo(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            int n = documentEvent.getLength();
            AppFrame.this.translationsArea.append(documentEvent.getType().toString() + ": " + n + " character" + (n == 1 ? ". " : "s. ") + " Text length = " + document.getLength() + "." + AppFrame.this.newline);
        }
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        public CaretListenerLabel(String string) {
            super(string);
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.displaySelectionInfo(caretEvent.getDot(), caretEvent.getMark());
        }

        private void displaySelectionInfo(final int n, final int n2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object object;
                    int n3 = 0;
                    int n22 = AppFrame.this.doc.getLength();
                    if (n == n2) {
                        try {
                            object = AppFrame.this.textPane.modelToView(n);
                            n3 = n;
                            n22 = Math.min(15, AppFrame.this.doc.getLength() - n);
                        }
                        catch (BadLocationException badLocationException) {}
                    } else if (n < n2) {
                        n3 = n;
                        n22 = n2 - n;
                    } else {
                        n3 = n2;
                        n22 = n - n2;
                    }
                    System.out.println("LET'S TRY...");
                    object = null;
                    try {
                        object = AppFrame.this.doc.getText(n3, n22);
                    }
                    catch (Exception exception) {
                        System.out.println("caught: " + exception);
                    }
                    System.out.println("  word = " + (String)object);
                    RcxData.DictionaryEntry[] dictionaryEntryArray = new RcxData.DictionaryEntry[]{};
                    RcxData.KanjiEntry kanjiEntry = new RcxData.KanjiEntry("-", "-", "-", "-", "-");
                    try {
                        if (((String)object).length() > 0) {
                            kanjiEntry = RcxData.kanjiSearch(((String)object).substring(0, 1));
                        }
                        System.out.println("kanjiSearch result : " + kanjiEntry);
                        dictionaryEntryArray = RcxData._wordSearch((String)object, AppConfig.INSTANCE.getDictionary(), 10);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < dictionaryEntryArray.length; ++i) {
                        RcxData.DictionaryEntry dictionaryEntry = dictionaryEntryArray[i];
                        if (!dictionaryEntry.word().equals("")) {
                            stringBuilder.append(dictionaryEntry.word()).append("  ");
                        }
                        stringBuilder.append(dictionaryEntry.reading()).append("  ");
                        stringBuilder.append(dictionaryEntry.gloss()).append("  ");
                        stringBuilder.append('\n');
                    }
                    AppFrame.this.translationsArea.setText(stringBuilder.toString());
                    AppFrame.this.translationsArea.setCaretPosition(0);
                }
            });
        }
    }
}

