/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.korenani;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AppConfig {
    public static final AppConfig INSTANCE = new AppConfig();
    private static final String CUSTOM_DIRECT_PATH_TO_DICTIONARY_DATABASE = System.getProperty("korenani.dictionary.database.custom.direct.path", null);
    private static final String CUSTOM_PATH_TO_DICTIONARY_JAR = System.getProperty("korenani.dictionary.jar.custom.path", null);
    private static final String DEFAULT_DIRECT_PATH_TO_DICTIONARY_DATABASE = "dictionaries/dict.sqlite";
    private static final String DEFAULT_PATH_TO_DICTIONARY_JAR = "dictionaries/default_jp_2_en_dict.jar";
    private static final String CUSTOM_PATH_TO_DICTIONARY_DATABASE;
    private static final String DEFAULT_PATH_TO_DICTIONARY_DATABASE;

    public static String getDictionary() {
        if (CUSTOM_DIRECT_PATH_TO_DICTIONARY_DATABASE != null && AppConfig.isPathExists(CUSTOM_DIRECT_PATH_TO_DICTIONARY_DATABASE)) {
            return CUSTOM_DIRECT_PATH_TO_DICTIONARY_DATABASE;
        }
        if (CUSTOM_PATH_TO_DICTIONARY_DATABASE != null && AppConfig.isPathExists(CUSTOM_PATH_TO_DICTIONARY_JAR)) {
            return CUSTOM_PATH_TO_DICTIONARY_DATABASE;
        }
        if (DEFAULT_DIRECT_PATH_TO_DICTIONARY_DATABASE != null && AppConfig.isPathExists(DEFAULT_DIRECT_PATH_TO_DICTIONARY_DATABASE)) {
            return DEFAULT_DIRECT_PATH_TO_DICTIONARY_DATABASE;
        }
        if (DEFAULT_PATH_TO_DICTIONARY_DATABASE != null) {
            if (AppConfig.isPathExists(DEFAULT_PATH_TO_DICTIONARY_JAR)) {
                return DEFAULT_PATH_TO_DICTIONARY_DATABASE;
            }
            return DEFAULT_PATH_TO_DICTIONARY_DATABASE;
        }
        return null;
    }

    private static boolean isPathExists(String string) {
        if (string == null) {
            return false;
        }
        Path path = Paths.get(string, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    static {
        DEFAULT_PATH_TO_DICTIONARY_DATABASE = AppConfig.isPathExists(DEFAULT_PATH_TO_DICTIONARY_JAR) ? ":resource:jar:file:dictionaries/default_jp_2_en_dict.jar!/dict.sqlite" : null;
        CUSTOM_PATH_TO_DICTIONARY_DATABASE = !AppConfig.isPathExists(CUSTOM_PATH_TO_DICTIONARY_JAR) ? null : ":resource:jar:file:" + CUSTOM_PATH_TO_DICTIONARY_JAR + "!/dict.sqlite";
        System.out.println("AppConfig (static block) - CUSTOM_DIRECT_PATH_TO_DICTIONARY_DATABASE == " + CUSTOM_DIRECT_PATH_TO_DICTIONARY_DATABASE + (AppConfig.isPathExists(CUSTOM_DIRECT_PATH_TO_DICTIONARY_DATABASE) ? " (INFO: path exists)" : " (INFO: PATH NOT FOUND)"));
        System.out.println("AppConfig (static block) - CUSTOM_PATH_TO_DICTIONARY_JAR == " + CUSTOM_PATH_TO_DICTIONARY_JAR + (AppConfig.isPathExists(CUSTOM_PATH_TO_DICTIONARY_JAR) ? " (INFO: path exists)" : " (INFO: PATH NOT FOUND)"));
        System.out.println("AppConfig (static block) - CUSTOM_PATH_TO_DICTIONARY_DATABASE == " + (AppConfig.isPathExists(CUSTOM_PATH_TO_DICTIONARY_JAR) ? CUSTOM_PATH_TO_DICTIONARY_DATABASE : " (INFO: JAR CONTAINER NOT FOUND)"));
        System.out.println("AppConfig (static block) - DEFAULT_DIRECT_PATH_TO_DICTIONARY_DATABASE == dictionaries/dict.sqlite" + (AppConfig.isPathExists(DEFAULT_DIRECT_PATH_TO_DICTIONARY_DATABASE) ? " (INFO: path exists)" : " (INFO: PATH NOT FOUND)"));
        System.out.println("AppConfig (static block) - DEFAULT_PATH_TO_DICTIONARY_JAR == dictionaries/default_jp_2_en_dict.jar" + (AppConfig.isPathExists(DEFAULT_PATH_TO_DICTIONARY_JAR) ? " (INFO: path exists)" : " (INFO: PATH NOT FOUND)"));
        System.out.println("AppConfig (static block) - DEFAULT_PATH_TO_DICTIONARY_DATABASE == " + (AppConfig.isPathExists(DEFAULT_PATH_TO_DICTIONARY_JAR) ? DEFAULT_PATH_TO_DICTIONARY_DATABASE : " (INFO: JAR CONTAINER NOT FOUND)"));
    }
}

