#include <time.h>
#include <sys/time.h>
#define USE_B
#include <konoha.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Time! Time.new(); */
METHOD Time_new(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	time_t timer;
	struct tm *date;

	time(&timer);
	date = localtime(&timer);

	// In glibc, we do not need to free "data".
	ctx->api->RawPtr_init(ctx, sfp[0].p, date, NULL);
	RETURN_(sfp[0].o);
}

/* Int Time.time(); */
METHOD Time_getTime(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	time_t timer;
	RETURNi_(time(&timer));
}

/* void Time.mktime(Time time); */
METHOD Time_mktime(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	time_t timer = mktime(date);
	RETURNi_(timer);
}

/* string Time.asctime() */
METHOD Time_asctime(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	char* ret = asctime(date);
	knh_String_t *s = ctx->api->new_String(ctx, ret);
	RETURN_(s);
}

/* Time! Time.gmtime() */
METHOD Time_gmtime(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	time_t timer;
	timer = mktime(date);
	date = gmtime(&timer);
	RETURN_(sfp[0].o);
}

/* Time! Time.localtime() */
METHOD Time_localtime(Ctx *ctx,knh_sfp_t *sfp, long rix){
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	time_t timer;
	date = localtime(&timer);
	RETURN_(sfp[0].o);
}

/* void Time.setTime(int year,int month,int day,int hour,int min,int sec); */

static int knh_time_julian_day_number(int year, int month, int day)
{
	int y = year;
	int m = (month < 3) ? (y--, month + 10) : month-2;
	return (int)(365.25 * y) + (int)(y / 400) - (int)(y / 100) + (int)(30.59 * m) + day - 678912;
}

static int knh_time_is_leap_year(int year)
{
	if (year % 400) return 1;
	else if (year % 4 && !(year % 100)) return 1;
	return 0;
}

static int knh_time_get_time_weekday(int year, int month, int day)
{
	int jnum = knh_time_julian_day_number(year, month, day);
	int wday_day[] = {3, 4, 5, 6, 0, 1, 2};
	return wday_day[jnum % 7];
}

static int knh_time_get_time_yearday(int year, int month, int day)
{
	int day_month[] = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
	int ret = day_month[month-1] + day;
	if (knh_time_is_leap_year(year)) ret++;
	return ret;
}

METHOD Time_setTime(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);

	int year = Int_to(int, sfp[1]);
	int month = Int_to(int, sfp[2]);
	int day = Int_to(int, sfp[3]);
	int yday = knh_time_get_time_yearday(year, month, day);
	int wday = knh_time_get_time_weekday(year, month, day);
	int hour = Int_to(int, sfp[4]);
	int min = Int_to(int, sfp[5]);
	int sec = Int_to(int, sfp[6]);
	
	date->tm_year = (year >= 1900) ? year - 1900 : 0;
	date->tm_mon = (month) ? month - 1 : 0;
	date->tm_mday = (day) ? day : 1;
	date->tm_yday = yday;
	date->tm_wday = wday;

	date->tm_hour = (hour) ? hour : 0;
	date->tm_min  = (min) ? min : 0;
	date->tm_sec  = (sec) ? sec : 0;
	RETURNvoid_();
}

/* int Time.getYear() */
METHOD Time_getYear(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	RETURNi_(date->tm_year+1900);
}

/* int Time.getMonth() */
METHOD Time_getMonth(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	RETURNi_(date->tm_mon+1);
}

/* int Time.getDay() */
METHOD Time_getDay(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	RETURNi_(date->tm_mday);
}

/* int Time.getHour() */
METHOD Time_getHour(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	RETURNi_(date->tm_hour);
}

/* int Time.getMinute() */
METHOD Time_getMinute(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	RETURNi_(date->tm_min);
}

/* int Time.getSecond() */
METHOD Time_getSecond(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	RETURNi_(date->tm_sec);
}

/* int Time.setYear() */
METHOD Time_setYear(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	int year = Int_to(int, sfp[1]);
	date->tm_year = year;
	RETURNvoid_();
}

/* int Time.setMonth() */
METHOD Time_setMonth(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	int month = Int_to(int, sfp[1]);
	date->tm_mon = month;
	RETURNvoid_();
}

/* int Time.setDay() */
METHOD Time_setDay(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	int day = Int_to(int, sfp[1]);
	date->tm_mday = day;
	RETURNvoid_();
}

/* int Time.setHour() */
METHOD Time_setHour(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	int hour = Int_to(int, sfp[1]);
	date->tm_hour = hour;
	RETURNvoid_();
}

/* int Time.setMinute() */
METHOD Time_setMinutes(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	int minutes = Int_to(int, sfp[1]);
	date->tm_min = minutes;
	RETURNvoid_();
}

/* int Time.setSecond() */
METHOD Time_setSecond(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	int second = Int_to(int, sfp[1]);
	date->tm_sec = second;
	RETURNvoid_();
}

/* String Time.strftime(String? fmt); */
METHOD Time_strftime(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	char buff[256] = {0};
	char *fmt = (IS_NULL(sfp[1].o)) ? "%s" : String_to(char*, sfp[1]);
	strftime(buff, 255, fmt, date);
	knh_String_t *s = ctx->api->new_String(ctx, buff);
	RETURN_(s);
}


METHOD Time_getTimeToSecond(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	struct timeval tv;
	gettimeofday(&tv, NULL);
	RETURNi_(tv.tv_sec);
}

METHOD Time_getTimeToUSecond(Ctx *ctx, knh_sfp_t *sfp, long rix)
{
	struct timeval tv;
	gettimeofday(&tv, NULL);
	RETURNi_(tv.tv_usec);
}

/* ------------------------------------------------------------------------ */
//## method void Time.%s(OutputStream w, String? fmt);
//## method void Time.%k(OutputStream w, String? fmt);

METHOD Time__s(Ctx *ctx,knh_sfp_t *sfp, long rix)
{
	struct tm *date = RawPtr_to(struct tm*, sfp[0]);
	char buff[256] = {0};
	knh_OutputStream_t *w = sfp[1].w;
	char *fmt = (IS_NULL(sfp[2].o)) ? "%s" : String_to(char*, sfp[2]);
	strftime(buff, 255, fmt, date);
	knh_OutputStream_write(ctx, w, B(buff));
	RETURNvoid_();
}

/* ------------------------------------------------------------------------ */

KNHAPI(int) kcheck(void)
{
	return K_BUILDID;
}

KNHAPI(void) init(Ctx *ctx, const knh_PackageLoaderAPI_t *kapi, char *dname, int isOVERRIDE)
{
	//static int isInit = 0;
	//if (isInit++ == 0) {
	//	knh_loadMethodData(ctx, MethodData);
	//	knh_loadMapperData(ctx, MapperData);
	//}
}

#ifdef __cplusplus
}
#endif

