/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [macros] */

#define _knh_Object_cid(o)           (o)->h.cid
#define _knh_Object_bcid(o)          (o)->h.bcid


///* ======================================================================== */
///* [COBJ] */
//
//static
//void knh_fcfree__default(Ctx *ctx, void *ptr, knh_ftraverse ftr)
//{
//	;
//}
//
///* ------------------------------------------------------------------------ */
//
//static
//Object *knh_fccopy__default(Ctx *ctx, knh_Glue_t *ptr)
//{
//	TODO();
//	return (Object*)ptr;
//}
//
///* ------------------------------------------------------------------------ */
//
//KNHAPI(void) knh_COBJ_init(Ctx *ctx, Object *o, void *ptr, knh_fgluefree cf, knh_fccopy cc)
//{
//	KNH_ASSERT(IS_bAny(o));
//	knh_Glue_t *c = (knh_Glue_t*)o;
//	if(ptr != NULL) {
//		c->cptr = ptr;
//		if(cf == NULL) cf = knh_fcfree__default;
//		c->cfree = cf;
//		if(cc == NULL) cc = knh_fccopy__default;
//		c->ccopy = cc;
//	}
//	else {
//		if(c->cptr != NULL) {
//			c->cfree(ctx, c->cptr, knh_Object_RCsweep);
//		}
//		c->cptr = NULL;
//		c->cfree = knh_fcfree__default;
//		c->ccopy = knh_fccopy__default;
//	}
//}

/* ======================================================================== */
/* [new] */
/* @method[VIRTUAL] This! Object.new() */

METHOD knh__Object_new(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, sfp[0].o);
}

/* ======================================================================== */
/* [copy] */

Object *knh_Object_copy(Ctx *ctx, Object *b)
{
	if(knh_Object_isImmutable(b)) {
		return b;
	}
	DBG2_P("!IMMUTABLE %s", CLASSN(knh_Object_cid(b)));
	return b;
}

/* ======================================================================== */
/* [commons] */

knh_hcode_t knh_Object_hashCode(Ctx *ctx, Object *o)
{
	return ctx->tStruct[o->h.bcid].fhashCode(ctx, o);
}

/* ------------------------------------------------------------------------ */

knh_bytes_t knh_Object_tobytes(Ctx *ctx, Object *o)
{
	switch(o->h.bcid) {
		case STRUCT_String : return knh_String_tobytes((String*)o);
		case STRUCT_Bytes : return knh_Bytes_tobytes((Bytes*)o);
	}
	TODO();
	return STEXT("");
}

/* ======================================================================== */
/* [structs] */

/* ======================================================================== */
/* [mapping] */


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

