/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"


/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [macros] */

#define _knh_Bytes_size(o)      (o)->size
#define _knh_Bytes_value(o)     (o)->buf
#define _knh_Bytes_last(o)      ((o)->buf + (o)->size)

/* ======================================================================== */
/* [barray] */

typedef struct { /* @data */
	size_t capacity;
} knh_barray_t ;

/* ------------------------------------------------------------------------ */

size_t knh_barray_capacity(void *a)
{
	if(a == NULL) {
		return 0;
	}
	else {
		knh_barray_t *h = ((knh_barray_t*)a);
		return h[-1].capacity;
	}
}

/* ------------------------------------------------------------------------ */

knh_uchar_t *knh_barray_malloc(Ctx *ctx, size_t capacity)
{
	capacity = KNH_SIZE(capacity);
	if(capacity > 0) {
		knh_barray_t *h = (knh_barray_t*)KNH_MALLOC(ctx, capacity + sizeof(knh_barray_t));
		h->capacity = capacity;
		knh_bzero(h+1, capacity);
		return (knh_uchar_t*)(h+1);
	}
	else {
		return NULL;
	}
}

/* ------------------------------------------------------------------------ */

void knh_barray_free(Ctx *ctx, knh_uchar_t *a)
{
	if(a != NULL) {
		knh_barray_t *h = ((knh_barray_t*)a) - 1;
		KNH_FREE(ctx, h, h->capacity + sizeof(knh_barray_t));
	}
}

/* ------------------------------------------------------------------------ */

static
knh_uchar_t *knh_barray_resize(Ctx *ctx, knh_uchar_t *a, size_t newsize)
{
	if(a == NULL) {
		return knh_barray_malloc(ctx, newsize);
	}
	else if(newsize == 0) {
		knh_barray_t *h = ((knh_barray_t*)a) - 1;
		KNH_FREE(ctx, h, h->capacity + sizeof(knh_barray_t));
		return NULL;
	}
	newsize = KNH_SIZE(newsize);
	{
		knh_barray_t *h = ((knh_barray_t*)a) - 1, *newh;
		knh_uchar_t *newa = NULL;
		size_t size = h->capacity;
		newh = (knh_barray_t*)KNH_MALLOC(ctx, newsize + sizeof(knh_barray_t));
		newh->capacity = newsize;
		newa = (knh_uchar_t*)(newh + 1);
		if(size > 0) {
			knh_memcpy(newa, a, size);
		}
		if(newsize > size) {
			knh_bzero(&newa[size], newsize - size);
		}
		KNH_FREE(ctx, h, h->capacity + sizeof(knh_barray_t));
		return newa;
	}
}

/* ======================================================================== */
/* [constructors] */

KNHAPI(Bytes*) new_Bytes(Ctx *ctx, size_t capacity)
{
	return (Bytes*)new_Object_bcid(ctx, CLASS_Bytes, capacity);
}

/* ======================================================================== */
/* [methods] */

KNHAPI(knh_bytes_t) knh_Bytes_tobytes(Bytes *o)
{
	knh_bytes_t v = {o->buf, o->size};
	return v;
}

#define _knh_Bytes_tochar(b)  (char*)knh_Bytes_value(b)

/* ------------------------------------------------------------------------ */

knh_bytes_t knh_BytesNULL_tobytes(Bytes *o)
{
	if(IS_NULL(o)) {
		knh_bytes_t v = {(knh_uchar_t*)"", 0};
		return v;
	}
	else {
		knh_bytes_t v = {o->buf, o->size};
		return v;
	}
}

/* ------------------------------------------------------------------------ */

char *knh_BytesNULL_tochar(Bytes *o)
{
	if(IS_NULL(o)) {
		return "";
	}
	else {
		return (char*)o->buf;
	}
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_Bytes_clear(Bytes *o)
{
	knh_bzero(o->buf, o->size);
	o->size = 0;
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_Bytes_putc(Ctx *ctx, Bytes *o, int ch)
{
	size_t capacity = knh_barray_capacity(o->buf);
	if(o->size == capacity) {
		if(o->buf == NULL) {
			o->buf = knh_barray_malloc(ctx, 256);
		}
		else {
			o->buf = knh_barray_resize(ctx, o->buf, capacity * 2);
		}
	}
	o->buf[o->size] = ch;
	o->size += 1;
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knh_Bytes_write(Ctx *ctx, Bytes *o, knh_bytes_t v)
{
	if(v.len == 0) {
		return ;
	}
	else {
		size_t capacity = knh_barray_capacity(o->buf);
		if(o->size + v.len >= capacity) {
			size_t newsize = capacity * 2;
			if(newsize < o->size + v.len) newsize = o->size + v.len;
			if(o->buf == NULL) {
				o->buf = knh_barray_malloc(ctx, newsize);
			}
			else {
				o->buf = knh_barray_resize(ctx, o->buf, newsize);
			}
		}
		knh_memcpy(&o->buf[o->size], v.buf, v.len);
		o->size += v.len;
	}
}

/* ------------------------------------------------------------------------ */

void knh_Bytes_unputc(Bytes *o)
{
	if(o->size > 0) {
		o->size -= 1;
		o->buf[o->size] = '\0';
	}
}

/* ======================================================================== */
/* [malloc] */

void *knh_Context_mallocOnce(Ctx* ctx, size_t n)
{
	KNH_ASSERT(knh_Bytes_size(ctx->bconvbuf) == 0);
	KNH_ASSERT(n > 0);
	Bytes *o = ctx->bconvbuf;
	size_t capacity = knh_barray_capacity(o->buf);
	if(o->size + n >= capacity) {
		size_t newsize = capacity * 2;
		if(newsize < o->size + n) newsize = o->size + n;
		o->buf = knh_barray_resize(ctx, o->buf, newsize);
	}
	return (void*)o->buf;
}

/* ------------------------------------------------------------------------ */

void knh_Context_freeOnce(Ctx* ctx, void *p)
{
	KNH_ASSERT(p == (void*)ctx->bconvbuf->buf);
	knh_Bytes_clear(ctx->bconvbuf);
}

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
