/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method[STATIC] InputStream! System.getIn() */

METHOD knh__System_getIn(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, DP(knh_rootSystem)->in);
}

//#include <dirent.h>
//#include <sys/stat.h>
//
///* ------------------------------------------------------------------------ */
///* @method[STATIC] void System.ls(String! dirname) */
//
//METHOD knh__System_ls(Ctx* ctx, knh_sfp_t *sfp)
//{
//	DIR *dirptr;
//	struct dirent *direntp;
//	struct stat fstat;
//	char *dirname = knh_String_tochar(sfp[1].s);
//
//	if ((dirptr = opendir(dirname)) == NULL) {
//			fprintf(stderr, "cannot opne %s \n", dirname);
//	} else {
//		while ((direntp = readdir(dirptr)) != NULL) {
//			stat(direntp->d_name, &fstat);
////			printf("%s %d %d %d\n", direntp->d_name, fstat.st_uid, fstat.st_gid, fstat.st_size);
//			printf("%s \n", direntp->d_name);
//		}
//		closedir(dirptr);
//	}
//	KNH_RETURN_void(ctx, sfp);
//}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] void System.setIn(InputStream in) */

METHOD knh__System_setIn(Ctx *ctx, knh_sfp_t *sfp)
{
	if(knh_Context_isAdmin(ctx)) {
		if(IS_NULL(sfp[1].o)) {
			KNH_SETv(ctx, DP(knh_rootSystem)->in, knh_tClass_defaultValueNN(ctx, CLASS_InputStream));
		}
		else {
			KNH_SETv(ctx, DP(knh_rootSystem)->in, sfp[1].o);
		}
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] OutputStream! System.getOut() */

METHOD knh__System_getOut(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, DP(knh_rootSystem)->out);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] void System.setOut(OutputStream out) */

METHOD knh__System_setOut(Ctx *ctx, knh_sfp_t *sfp)
{
	if(knh_Context_isAdmin(ctx)) {
		if(IS_NULL(sfp[1].o)) {
			KNH_SETv(ctx, DP(knh_rootSystem)->out, knh_tClass_defaultValueNN(ctx, CLASS_OutputStream));
		}
		else {
			KNH_SETv(ctx, DP(knh_rootSystem)->out, sfp[1].o);
		}
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] OutputStream! System.getErr() */

METHOD knh__System_getErr(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, DP(knh_rootSystem)->err);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] void System.setStdErr(OutputStream out) */

METHOD knh__System_setErr(Ctx *ctx, knh_sfp_t *sfp)
{
	if(knh_Context_isAdmin(ctx)) {
		if(IS_NULL(sfp[1].o)) {
			KNH_SETv(ctx, DP(knh_rootSystem)->err, knh_tClass_defaultValueNN(ctx, CLASS_OutputStream));
		}
		else {
			KNH_SETv(ctx, DP(knh_rootSystem)->err, sfp[1].o);
		}
	}
	KNH_RETURN_void(ctx, sfp);
}


/* ------------------------------------------------------------------------ */
/* @method[STATIC] void System.gc() */

METHOD knh__System_gc(Ctx *ctx, knh_sfp_t *sfp)
{
	//knh_collect(ctx);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] void System.exit(Int status) */

METHOD knh__System_exit(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_int_t status = IS_NULL(sfp[1].o) ? 0 : p_int(sfp[1]);
	KNH_SECURE(ctx);
	KNH_NOTICE(ctx, "exiting by a user");
	exit((int)status);
	KNH_RETURN_void(ctx, sfp);
}

/* ======================================================================== */
/* [movabletext] */

/* @method void System.%k(OutputStream w, String m) */

void knh_System__k(Ctx *ctx, System *o, OutputStream *w, String *m)
{
	char *_PREVIEW_ = (KONOHA_BUILDID % 2 == 1) ? " _PREVIEW_" : "";
#ifdef KONOHA_UNDER_GPL2
	knh_printf(ctx, w, "Konoha %s%s GPL2 (#%d, %s, %s)", KONOHA_VERSION, _PREVIEW_, KONOHA_BUILDID, __DATE__, __TIME__);
#else
	knh_printf(ctx, w, "Konoha %s%s (#%d, %s, %s)" TERM_INIT, KONOHA_VERSION, _PREVIEW_, KONOHA_BUILDID, __DATE__, __TIME__);
#endif
}


/* ------------------------------------------------------------------------ */
/* @method void System.%dump(OutputStream w, String m) */

void knh_System__dump(Ctx *ctx, System *o, OutputStream *w, String *m)
{
	knh_System__k(ctx, o, w, m);
	knh_write_EOL(ctx, w);
	knh_printf(ctx, w, "[%s] on %s (%d, %s, %s)\n", KONOHA_CC_VERSION, KONOHA_OS,
			sizeof(void*) * 8, konoha_encoding(), knh_message_text(KMSG_LANG));
	knh_write__s(ctx, w, "Options:");

#ifdef KNH_FASTMODE
	knh_write__s(ctx, w, " fastmode");
#endif

#ifdef KNH_USING_ICONV
	knh_write__s(ctx, w, " iconv");
#endif
#ifdef KNH_USING_INT32
	knh_write__s(ctx, w, " int32");
#endif
#ifdef KNH_USING_MATH
	knh_write__s(ctx, w, " math");
#endif
	knh_write_USING_SQLITE3(ctx, w);
#ifdef KNH_USING_THREAD
	knh_write__s(ctx, w, " thread");
#endif
	knh_write_USING_REGEX(ctx, w);
	knh_write_EOL(ctx, w);
}

/* ======================================================================== */
/* [Context] */

/* ------------------------------------------------------------------------ */
/* @method Any Context.getProperty(String! key) */

Object* knh_Context_getProperty(Ctx *ctx, Context *b, knh_bytes_t key)
{
	Object *v = knh_DictMap_get__b( b->props, key);
	if(IS_NULL(v)) {
		return knh_System_getProperty(ctx, knh_rootSystem, key);
	}
	return v;
}

/* ------------------------------------------------------------------------ */
/* @method void Context.setProperty(String! key, Any value) */

void knh_Context_setProperty(Ctx *ctx, Context *b, String *key, Any *value)
{
	knh_DictMap_set(ctx, b->props, key, value);
}

/* ------------------------------------------------------------------------ */
/* @method void Context.setEncoding(String enc) */

void knh_Context_setEncoding(Ctx *ctx, knh_Context_t *o, String *enc)
{
	if(IS_NULL(enc)) {
		enc = knh_systemEncoding;
	}
	KNH_SETv(ctx, o->enc, enc);
	if(knh_bytes_strcasecmp(knh_String_tobytes(enc), STEXT(KONOHA_ENCODING))==0) {
		KNH_SETv(ctx, DP(o->in)->bconv, KNH_NULL);
		KNH_SETv(ctx, DP(o->out)->bconv, KNH_NULL);
		KNH_SETv(ctx, DP(o->err)->bconv, KNH_NULL);
	}
	else {
		BytesConv *bin = new_BytesConv__in(ctx, knh_String_tochar(enc));
		BytesConv *bout = new_BytesConv__out(ctx, knh_String_tochar(enc));
		if(IS_NULL(bin) || IS_NULL(bout)) {
			KNH_WARNING(ctx, "unsupported character encoding: %s", knh_String_tochar(enc));
		}
		KNH_SETv(ctx, DP(o->in)->bconv, bin);
		KNH_SETv(ctx, DP(o->out)->bconv, bout);
		KNH_SETv(ctx, DP(o->err)->bconv, bout);
	}
}

/* ------------------------------------------------------------------------ */
/* @method void Context.setIn(InputStream in) */

METHOD knh__Context_setIn(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(ctx == (Ctx*)sfp[0].o);
	if(IS_NULL(sfp[1].o)) {
		KNH_SETv(ctx, ((Context*)ctx)->in, knh_tClass_defaultValueNN(ctx, CLASS_InputStream));
	}
	else {
		KNH_SETv(ctx, ((Context*)ctx)->in, sfp[1].o);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method void Context.setOut(OutputStream in) */

METHOD knh__Context_setOut(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(ctx == (Ctx*)sfp[0].o);
	if(IS_NULL(sfp[1].o)) {
		KNH_SETv(ctx, ((Context*)ctx)->out, knh_tClass_defaultValueNN(ctx, CLASS_OutputStream));
	}
	else {
		KNH_SETv(ctx, ((Context*)ctx)->out, sfp[1].o);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method void Context.setErr(OutputStream out) */

METHOD knh__Context_setErr(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_ASSERT(ctx == (Ctx*)sfp[0].o);
	if(IS_NULL(sfp[1].o)) {
		KNH_SETv(ctx, ((Context*)ctx)->err, knh_tClass_defaultValueNN(ctx, CLASS_OutputStream));
	}
	else {
		KNH_SETv(ctx, ((Context*)ctx)->err, sfp[1].o);
	}
	KNH_RETURN_void(ctx, sfp);
}

///* ------------------------------------------------------------------------ */
//
//void knhctx_setEncoding(Ctx *ctx, String *enc)
//{
//	TODO();
//}
//
///* ------------------------------------------------------------------------ */
//
//String* knhctx_getEncoding(Ctx *ctx)
//{
//	TODO();
//}
//
///* ------------------------------------------------------------------------ */
///* @method String! Context.getLanguage() */
//
//void knh_Context_setLanguage(Ctx *ctx, Context *o)
//{
//	TODO();
//}
//
///* ------------------------------------------------------------------------ */
///* @ method void Context.setLanguage(String! lang) */
//
//void knh_Context_setLanguage(Ctx *ctx, Context *o, String *lang)
//{
//	TODO();
//}
//
///* ------------------------------------------------------------------------ */
///* @ method String! Context.getLanguage() */
//
//String *knh_Context_getLanguage(Ctx *ctx, Context *o)
//{
//	TODO();
//}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [movabletext] */

/* @method void Context.%dump(OutputStream w, String m) */

void knh_Context__dump(Ctx *ctx, Context *b, OutputStream *w, String *m)
{
//	knh_int_t i = 0;
//	for(i = b->ebp - b->stack; i >= 0; i--) {
//		knh_printf(ctx, w, "[%d]\t%o\n", i, b->stack[i]);
//	}
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
