/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [macros] */

#define _knh_tstruct_isNative(sid)   (sid < KONOHA_TSTRUCT_SIZE)

/* ======================================================================== */
/* [structs] */

void
knh_ClassStruct_struct_init(Ctx *ctx, knh_ClassStruct_struct *b, int init, Object *cs)
{
	b->sid = 0;
	b->fsize = init;
	if(b->fsize == 0) {
		b->fields = NULL;
	}else {
		b->fields = (knh_cfield_t*)KNH_MALLOC(ctx, b->fsize * sizeof(knh_cfield_t));
		knh_int_t i;
		for(i = 0; i < b->fsize; i++) {
			b->fields[i].flag = 0;
			b->fields[i].type = TYPE_any;
			b->fields[i].fn   = FIELDN_NONAME;
			KNH_INITv(b->fields[i].value, KNH_NULL);
		}
	}
	b->methods = NULL;
}

/* ------------------------------------------------------------------------ */

#define _knh_ClassStruct_struct_copy    NULL

/* ------------------------------------------------------------------------ */

void
knh_ClassStruct_struct_traverse(Ctx *ctx, knh_ClassStruct_struct *b, knh_ftraverse gc)
{
	if(b->fields != NULL) {
		knh_int_t i;
		for(i = 0; i < b->fsize; i++) {
			gc(ctx, b->fields[i].value);
		}
		if(IS_SWEEP(gc)) {
			KNH_FREE(ctx, b->fields, b->fsize * sizeof(knh_cfield_t));
		}
	}
	gc(ctx, UP(b->methods));
}

/* ======================================================================== */
/* [constructors] */

ClassStruct* new_ClassStruct0(Ctx *ctx, knh_struct_t sid, int method_size)
{
	knh_ClassStruct_t* o =
		(knh_ClassStruct_t*)new_Object_malloc(ctx, FLAG_ClassStruct, CLASS_ClassStruct, sizeof(knh_ClassStruct_struct));
	if(STRUCT_ISFIELD(sid)) {
		knh_ClassStruct_struct_init(ctx, DP(o), STRUCT_FIELDSIZE(sid), NULL);
	}
	else {
		knh_ClassStruct_struct_init(ctx, DP(o), 0 /* (knh_tStruct[sid].size / sizeof(Object*)) */, NULL);
	}
	KNH_INITv(DP(o)->methods, new_Array0(ctx, method_size));
	DP(o)->sid = sid;
	return o;
}

/* ======================================================================== */
/* [finit] */

void knh_ClassStruct_finit(Ctx *ctx, ClassStruct *o, knh_class_t self_cid, Object **v)
{
	size_t i;
	knh_cfield_t *cf = DP(o)->fields;
	for(i = 0; i < DP(o)->fsize; i++) {
		if(IS_NULL(cf[i].value) && IS_NNTYPE(cf[i].type)) {
			knh_class_t cid = knh_pmztype_toclass(ctx, cf[i].type, self_cid);
			KNH_INITv(v[i], new_Object__init(ctx, 0, cid));
		}
		else {
			KNH_INITv(v[i], cf[i].value);
		}
	}
}

/* ======================================================================== */
/* [field] */

knh_index_t knh_Class_indexOfField(knh_class_t cid, knh_fieldn_t fn)
{
	L_TAIL:;
	KNH_ASSERT_cid(cid);
	{
		knh_index_t idx = -1;
		ClassStruct *o = knh_tClass[cid].cstruct;

		if(DP(o)->fields != NULL) {
			for(idx = 0; idx < DP(o)->fsize; idx++) {
				if(DP(o)->fields[idx].fn == fn) {
					return knh_tClass[cid].offset + idx;
				}
			}
			idx = -1;
		}
		if(knh_tClass[cid].offset == 0) return -1;
		cid = knh_tClass[cid].supcid;
	}
	goto L_TAIL;
}

/* ------------------------------------------------------------------------ */

knh_index_t knh_Class_queryField(knh_class_t cid, knh_fieldn_t fnq)
{
	knh_fieldn_t fn = FIELDN_UNMASK(fnq);
	L_TAIL:;
	KNH_ASSERT_cid(cid);
	{
		ClassStruct *o = knh_tClass[cid].cstruct;
		knh_index_t idx = -1;
		if(FIELDN_IS_SUPER(fnq)) {
			fnq = fn;
			goto L_SUPER;
		}
		if(DP(o)->fields != NULL) {
			for(idx = 0; idx < DP(o)->fsize; idx++) {
				if(DP(o)->fields[idx].fn == fn) {
					return knh_tClass[cid].offset + idx;
				}
			}
			idx = -1;
		}
		L_SUPER:;
		if(knh_tClass[cid].offset == 0) return -1;
		cid = knh_tClass[cid].supcid;
		goto L_TAIL;
	}
}

/* ------------------------------------------------------------------------ */

knh_cfield_t *knh_Class_fieldAt(knh_class_t cid, size_t n)
{
	KNH_ASSERT_cid(cid);
	KNH_ASSERT(0 <= n && n < knh_tClass[cid].size);
	L_TAIL:;
	{
		ClassStruct *o = knh_tClass[cid].cstruct;;
		size_t offset = knh_tClass[cid].offset;
		if(offset <= n) {
			if(DP(o)->fields == NULL) {
				return NULL;
			}
			else {
				return &(DP(o)->fields[n - offset]);
			}
		}
		KNH_ASSERT_cid(cid);
		cid = knh_tClass[cid].supcid;
	}
	goto L_TAIL;
}


/* ------------------------------------------------------------------------ */
/* [movabletext] */

void knh_cfield_dump(Ctx *ctx, knh_cfield_t *f, size_t offset, size_t fsize, OutputStream *w)
{
	size_t idx = 0;
	for(idx = 0; idx < fsize; idx++) {
		if(f[idx].fn == FIELDN_NONAME) {
			knh_printf(ctx, w, "[%d] -\n", (offset+idx));
			continue;
		}
		knh_printf(ctx, w, "[%d] %F %T %N = %O\n", (offset+idx), f[idx].flag, f[idx].type, f[idx].fn, f[idx].value);
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
