/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* @method This! DictMap.new(Int n) */

METHOD knh__DictMap_new(Ctx *ctx, knh_sfp_t *sfp)
{
	DictMap *o = (DictMap*)sfp[0].o;
	size_t init = IS_NULL(sfp[1].o) ? KNH_DICTMAP_INITSIZE: ARG_int(sfp[1]);
	if(init > 0) {
		o->_list = knh_dictmap_malloc(ctx, init);
		o->size = 0;
	}
	KNH_RETURN(ctx, sfp, o);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS] This! DictMap.new:init(Any1 value) @VARARGS */

METHOD knh__DictMap_new__init(Ctx *ctx, knh_sfp_t *sfp)
{
	DictMap *o = (DictMap*)sfp[0].o;
	knh_sfp_t *v = sfp + 1;
	knh_vargc_t ac = knh_sfp_argc(ctx, v);
	size_t i;
	for(i = 0; i < ac; i+=2) {
		knh_DictMap_append(ctx, o, v[i].s, v[i+1].o);
	}
	knh_DictMap_sort(o);
	KNH_RETURN(ctx, sfp, o);
}

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method Any1 DictMap.get(String! key) */

METHOD knh__DictMap_get(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, knh_DictMap_get(ctx, (DictMap*)sfp[0].o, sfp[1].s));
}

/* ------------------------------------------------------------------------ */
/* @method Boolean! DictMap.opHas(String! key) */

METHOD knh__DictMap_opHas(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, knh_DictMap_index__b((DictMap*)sfp[0].o, knh_String_tobytes(sfp[1].s)) != -1);
}

/* ------------------------------------------------------------------------ */
/* @method void DictMap.set(String! key, Any1 value) */
/* @method void DictMap.set(String! key, Any1 value) */

METHOD knh__DictMap_set(Ctx *ctx, knh_sfp_t *sfp)
{
	DictMap *o = (DictMap*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_DictMap_set(ctx, o, sfp[1].s, sfp[2].o);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method void DictMap.remove(String! key) */

METHOD knh__DictMap_remove(Ctx *ctx, knh_sfp_t *sfp)
{
	DictMap *o = (DictMap*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_DictMap_remove(ctx, o, sfp[1].s);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method void DictMap.clear() */

METHOD knh__DictMap_clear(Ctx *ctx, knh_sfp_t *sfp)
{
	DictMap *o = (DictMap*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_DictMap_clear(ctx, o);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ======================================================================== */
/* @method Int! DictMap.getSize() */

METHOD knh__DictMap_getSize(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, knh_DictMap_size((DictMap*)sfp[0].o));
}

/* ------------------------------------------------------------------------ */

#define OPSUBSET   0
#define OPSUBSETE  1
#define OPOFFSET   2

METHOD knh__DictMap_subset(Ctx *ctx, knh_sfp_t *sfp, int mode)
{
	DictMap *o = (DictMap*)sfp[0].o;
	size_t i, s = 0, e = o->size;
	if(IS_NOTNULL(sfp[1].o)) {
		knh_bytes_t cs = knh_String_tobytes(sfp[1].s);
		for(i = 0; i < o->size; i++) {
			knh_bytes_t ks = knh_String_tobytes(knh_DictMap_keyAt(o, i));
			if(knh_bytes_strcmp(cs, ks) <= 0) {
				s = i;
			}
			else {
				break;
			}
		}
	}
	if(IS_NOTNULL(sfp[2].o)) {
		if(mode == OPSUBSETE) {
			knh_bytes_t cs = knh_String_tobytes(sfp[2].s);
			for(i = s; i < o->size; i++) {
				knh_bytes_t ks = knh_String_tobytes(knh_DictMap_keyAt(o, i));
				if(knh_bytes_strcmp(ks, cs) <= 0) {
					continue;
				}
				else {
					e = i;
					break;
				}
			}
		}
		else if(mode == OPSUBSET) {
			knh_bytes_t cs = knh_String_tobytes(sfp[2].s);
			for(i = s; i < o->size; i++) {
				knh_bytes_t ks = knh_String_tobytes(knh_DictMap_keyAt(o, i));
				if(knh_bytes_strcmp(ks, cs) < 0) {
					continue;
				}
				else {
					e = i;
					break;
				}
			}
		}
		else {
			e = s + ARG_int(sfp[2]);
			if(!(e < o->size)) {
				e = o->size;
			}
			else if(e < s) {
				e = s;
			}
		}
	}
	{
		DictMap *d = new_DictMap(ctx, knh_tClass[knh_Object_cid(o)].p1, e - s);
		for(i = s; i < e; i++) {
			knh_DictMap_append(ctx, d, knh_DictMap_keyAt(o, i), knh_DictMap_valueAt(o, i));
		}
		KNH_RETURN(ctx, sfp, d);
	}
}

/* ------------------------------------------------------------------------ */
/* @method This! DictMap.opSubsete(String s, String e) */

METHOD knh__DictMap_opSubsete(Ctx *ctx, knh_sfp_t *sfp)
{
	knh__DictMap_subset(ctx, sfp, OPSUBSETE);
}

/* ------------------------------------------------------------------------ */
/* @method This! DictMap.opSubset(String s, String e) */

METHOD knh__DictMap_opSubset(Ctx *ctx, knh_sfp_t *sfp)
{
	knh__DictMap_subset(ctx, sfp, OPSUBSET);
}

/* ------------------------------------------------------------------------ */
/* @method This! DictMap.opOffset(String s, Int! n) */

METHOD knh__DictMap_opOffset(Ctx *ctx, knh_sfp_t *sfp)
{
	knh__DictMap_subset(ctx, sfp, OPOFFSET);
}

/* ------------------------------------------------------------------------ */

static
String* knh_Object_key(Ctx *ctx, Object *o)
{
	switch(o->h.bcid) {
	case CLASS_String:
		return (String*)o;
	}
	{
		char buf[80];
		knh_snprintf(buf, sizeof(buf), "&%p", o);
		return new_String(ctx, B(buf), NULL);
	}
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS] void DictMap.opLshift(Any v) @VARARGS */

METHOD knh__DictMap_opLshift(Ctx *ctx, knh_sfp_t *sfp)
{
	DictMap *o = (DictMap*)sfp[0].o;
	if(!knh_Object_isImmutable(o)) {
		knh_sfp_t *v = sfp + 1;
		knh_vargc_t ac = knh_sfp_argc(ctx, v);
		size_t i;
		for(i = 0; i < ac; i++) {
			if(IS_NULL(v[1].o)) continue;
			String *key = knh_Object_key(ctx, v[i].o);
			knh_DictMap_append(ctx, o, key, v[i].o);
		}
		knh_DictMap_sort(o);
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */

/* ======================================================================== */
/* [iterators] */

Object *knh_DictMap_key_next(Ctx *ctx, Iterator *it)
{
	DictMap *o = (DictMap*)knh_Iterator_source(it);
	size_t pos;
	for(pos = knh_Iterator_pos(it); pos < o->size; pos++) {
		if(IS_NOTNULL(o->list[pos].value)) {
			knh_Iterator_setpos(it,pos+1);
			return (Object*)o->list[pos].key;
		}
	}
	knh_Iterator_setpos(it, pos);
	return (Object*)KNH_NULL;
}

/* ------------------------------------------------------------------------ */
/* @map DictMap Iterator! */

Iterator* knh_DictMap_Iterator(Ctx *ctx, DictMap *o, Mapper *mpr)
{
	knh_DictMap_sort(o);
	return new_Iterator(ctx, CLASS_String, UP(o), knh_DictMap_key_next);
}

/* ------------------------------------------------------------------------ */
/* @map DictMap String..! */

Iterator* knh_DictMap_String__(Ctx *ctx, DictMap *o, Mapper *mpr)
{
	knh_DictMap_sort(o);
	return new_Iterator(ctx, CLASS_String, UP(o), knh_DictMap_key_next);
}

/* ------------------------------------------------------------------------ */
/* @method String.. DictMap.opItr() */

METHOD knh__DictMap_opItr(Ctx *ctx, knh_sfp_t *sfp)
{
	DictMap *o = (DictMap*)sfp[0].o;
	knh_DictMap_sort(o);
	KNH_RETURN(ctx, sfp, new_Iterator(ctx, CLASS_String, UP(o), knh_DictMap_key_next));
}

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void DictMap.%k(OutputStream w, String m) */

void knh_DictMap__k(Ctx *ctx, DictMap *o, OutputStream *w, String *m)
{
	knh_DictMap_sort(o);
	knh_putc(ctx, w, '{');
	size_t c;
	for(c = 0; c < o->size; c++) {
		if(c > 0) {
			knh_write_delim(ctx, w);
		}
		knh_write(ctx, w, knh_String_tobytes(o->list[c].key));
		knh_putc(ctx, w, ':');	knh_putc(ctx, w, ' ');
		knh_format(ctx, w, METHODN__k, o->list[c].value, KNH_NULL);
	}
	knh_putc(ctx, w, '}');
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
