# script language for multi-meaning exec by byte shift 
# bytecode , stack , dictionary


require 'ko-byte-dictionary'
require 'thread'

class Hash
  def dump(sep=" ")
    self.invert.keys.sort.each{|k|
      print k+"=>"+self.invert[k]+sep
    }
    puts
  end
end

$escape="\\"

$pair ={
  "(" => ")",
  "{" => "}",
  "[" => "]",
  "<" => ">"
}

def pair key
  $pair[key]||key
end

def escaped val
  for key in [")","}","]","/"]
    val="\\"+val if key==val
  end
  val
end


def dicreset
  $dic=$dicdef #.clone
end

dicreset

$uselinecomment=true
$addlen=2
$addressint=false
$bufadr=0
$promptf =false
$vardic ={}
$localvardic ={}
$statestack=[]
$thread=[]
$helpfile="bytecode-his.txt"

def statedump dic
  p dic,$mem,$stack,$vardic,$pair
  print "state:"
  p $statestack
end

def v var
  $vardic[var]
end

def pop
  $stack.pop
end

def push a
  $stack <<a
end

def dicgets
  puts "change bytecode dic, please input each (1 byte code)"
  cid=$dic.invert
  cid.keys.sort.each{|key|
    print key+"=>"
    gets
    $dic[cid[key]]=$_.chomp
  }
  p $dic if $debug
end

def dicrot
  tdic=$dic.invert
  d=tdic.keys.sort
  tmp=tdic[d[0]]
  (d.size-1).times{|i|
    tdic[d[i]]=tdic[d[i+1]]
  }
  tdic[d[-1]]=tmp
  $dic=tdic.invert
end

def getjpadd da
  p da if $debug
  if $addlen==2
    $addressint ? da[1,2].to_i : da[1]*256+da[2]
  else
    $addressint ? da[1,1].to_i : da[1]
  end
end

def dicsetl str
  i=0
  $dic.keys.sort.each{|key|
    $dic[key]=str[i,1]
    i +=1
  }
end

def getcstr str
  /(.*)#{0.chr}?/=~str
  return [$1.length,$1] if $&
  [str.length, str]
end

def stackerror n
  if n==0
    puts "Hello, world!"
  else
    puts "͂悤"
  end
end

$stack=[]
$mem=""

def getvar a
  return $localvardic[a] if $localvardic.key? a
  $vardic[a]
end

def assign a, value, dic="global"
  if dic=="local" || $localvardic.key?(a)
    $localvardic[a] =value 
  else
    $vardic[a] =value
  end
end

def runbycode mem, pos, dic
  src =mem[pos..-1]
  if $debug
    puts "src:"+src  
    print "stack:";p $stack
    print "var:";p $vardic
    print "state_stack:";p $statestack
  end
  return false if  src==nil || src.length<1
  begin
    puts "code=`"+src[0..0]+"`" if $debug
    case src[0..0]
    when $escape
      dicreset
      return 1
    when dic["puts"]
      if $stack.size==0
        stackerror 0
      else
        puts $stack[-1]
      end
      return 1
    when dic["print"]
      if $stack.size==0
        stackerror 1
      else
        print $stack[-1]
      end
      return 1
    when dic["peek"]
      adr=getjpadd(src[1..-1])
      $stack <<mem[adr,1]
      return 1+$addlen
    when dic["poke"]
      adr=getjpadd(src[1..-1])
      mem[adr]=src[$addlen+1,1]
      return 2+$addlen
    when dic["putsbuf"]
      # puts string in buf, until delim
      return "p"+src[1,1]
    when dic["p"]
      # puts string
      len=src[1,1].to_i
      puts "len:"+len.to_s if $debug
      puts src[2,len]
      return 2+len
    when dic["cmp"]
      # cmp and set flag
      a = $stack.pop
      b = $stack.pop
      #p a==b,a.to_s,b.to_s
      case 
      when a==b
        $stack.push(true)
      else
        $stack.push(false)
      end
      p $stack if $debug
      return 1
    when dic["evalpush"]
      endm=escaped(pair(src[0,1]))
      /^(.)([^#{endm}]*)#{endm}/ =~ src
      eval("a=["+$2+"]")
      $stack.concat(a)
      return $&.length
    when dic["pushquote"]
      endm=escaped(pair(src[0,1]))
      /^(.)([^#{endm}]*)#{endm}/ =~ src
      $stack <<$2
      return $&.length
    when dic["pushquotes"]
      endm=escaped(pair(src[0,1]))
      /^(.)([^#{endm}]*)#{endm}/ =~ src
      $stack <<$2
      return $&.length
    when dic["push"]
      case src[1,1]
      when "i"
        # integer, 1 byte
        $stack<<src[2,1].to_i
        return 3
      when "n"
        #quoted num
        li=src[2,1]
        /^(#{li})([^#{li}]+)#{li}/ =~ src[2..-1]
        a=eval($2).to_s
        if a==$2
          a=eval($2)
        else
          a=$2.to_i 
        end
        $stack<<a
        return 4+$2.length
      when "a"
        $stack<<src[2,1]
        return 3
      when "z"
        #c style (zero stop) str
        strlen,str = getcstr(src[2..-1])
        $stack<<str
        return 3+strlen
      when "s"
        #quoted str
        li=src[2,1]
        /^(#{li})([^#{li}]+)#{li}/ =~ src[2..-1]
        $stack<<$2
        return 4+$2.length
      when "f"
        #quoted filename
        li=src[3,1]
        /^(#{li})([^#{li}]+)#{li}/ =~ src[3..-1]
        open($2){|f|
          case src[2,1]
          when "a"
            $stack <<f.readlines
          when "b"
            f.each_byte{|i| $stack <<i.chr }
          when "l"
            f.each{|i| $stack <<i }
          else
          end
        }
        return 5+$2.length
      else
      end
      return 1
    when dic["pop"]
      a=$stack.pop
      case src[1,1]
      when "f"
        #write data to quoted filename
        li=src[2,1]
        /^(#{li})([^#{li}]+)#{li}/ =~ src[2..-1]
        open($2,"w"){|f|
          f.puts a
        }
        return 4+$2.length
      when "F"
        #write data to quoted filename, append
        li=src[2,1]
        /^(#{li})([^#{li}]+)#{li}/ =~ src[2..-1]
        open($2,'a'){|f|
          f.puts a
        }
        return 4+$2.length
      when "p"
        case a
        when String
          src[1,1]=a[0,1]
        when Fixnum || Bignum
          src[1,1]=a.chr if a<256
        else
        end
        return 1
      else
      end
      return 1
    when dic["clear"]
      $stack=[]
      return 1
    when dic["dup"]
      $stack<<$stack[-1]
      return 1
    when dic["exch"]
      a =$stack.pop
      b =$stack.pop
      $stack <<a
      $stack <<b
      return 1
    when dic["index"]
      endm=escaped(pair(src[0,1]))
      if src[1,1]==dic["index"]
        /...*#{endm}{2}/ =~ src[0..-1]
        return $&.length
      else
        /.([^#{endm}]*)#{endm}/ =~ src[0..-1]
        i=$1
        tmp =$stack[-1]
        $stack <<tmp[eval(i)]
        return $&.length
      end
    when dic["pos"]
      po=-src[1,1].to_i-1
      $stack <<$stack[po]
      p $stack if $debug
      return 2
    when dic["copy"]
      po=-src[1,1].to_i-1
      $stack +=$stack[po..-1]
      p $stack if $debug
      return 2
    when dic["jp"]
      # jump ++
      to = ($addressint ? src[1,1].to_i: src[1])
      p "jp "+to.to_s if $debug
      return to
    when dic["jp-"]
      # jump --
      to = ($addressint ? src[1,1].to_i: src[1])
      p "jp -"+to.to_s if $debug
      return to
    when dic["jpto"]
      # jump to .. (2 byte)
      to =getjpadd(src)
      p "jp to"+to.to_s if $debug
      return "j",to
    when dic["jpLabel"]
      case src[1,1]
      when "b" # byte
        # jump to 'arg(1byte)'
        lab=src[2,1]
        /(.)([^#{lab}]*)#{lab}/ =~ src[3..-1]
        if $stack.pop
          return 3+$&.length
        end
      when "s" # str
        /^[^ ;\n]*/ =~ src[2..-1]
        lab=$&
        return ["label",lab]
      else
      end
      return 1
    when dic["dicgets"]
      # change dic
      dicgets
      return 1
    when dic["dicswap"]
      # change dic [a,b]=>[b,a]
      a=dic.invert[src[1,1]]
      b=dic.invert[src[2,1]]
      dic[a] = src[2,1]
      dic[b] = src[1,1]
      return 3
    when dic["dicrot"]
      # dic rotate
      $stack.pop.to_i.times{ dicrot }
      p $dic if $debug
      return 1
    when dic["dicset"]
      # set dic one, by following 2 byte
      $dic[$dic.invert[src[1,1]]]=src[2,1]
      return 3
    when dic["dicstack"]
      # set dic from stack
      dicsetl($stack.pop)
      return 1
    when dic["buf"]
      # set buf-address for gets
      $bufadr = getjpadd(src)
      return 3
    when dic["getsbuf"]
      gets
      return "g"+$_.chomp
    when dic["adrlensw"]
      # change jump.address.length
      $addlen = ($addlen==1 ? 2: 1)
      return 1
    when dic["adrintsw"]
      # jump.address as integer
      $addressint = ! $addressint
      return 1
    when dic["call"]
      # 2 byte
      to =getjpadd(src)
      p "call "+to.to_s if $debug
      return "c"+src[1,$addlen]
    when dic["ret"]
      # return
      p "ret" if $debug
      return "r"
    when dic["dump"]
      case src[1,1]
      when 'a'
        statedump dic
      when 'd'
        dic.dump
      when 'e'
        p $statestack
      when 'm'
        p $mem
      when 'p'
        p $pair
      when 's'
        p $stack
      when ','
        puts $stack
      when 't'
        p $thread
      when 'v'
        print"var:";p $vardic
        print"local var:";p $localvardic
      else
        puts "?"
      end
      return 2
    when dic["plus"]
      b,a = $stack.pop, $stack.pop
      $stack <<a+b
      return 1
    when dic["minus"]
      b,a = $stack.pop, $stack.pop
      $stack <<a-b
      return 1
    when dic["neg"]
      a = $stack.pop
      $stack <<-a
      return 1
    when dic["mod"]
      b,a = $stack.pop, $stack.pop
      $stack <<a%b
      return 1
    when dic["div"]
      b,a = $stack.pop, $stack.pop
      if a.class==String
        $stack <<a.split(b.to_s)
      else
        $stack <<a/b
      end
      return 1
    when dic["mul"]
      b,a = $stack.pop, $stack.pop
      $stack <<a*b
      return 1
    when dic["to_i"]
      a = $stack.pop
      $stack <<a.to_i
      return 1
    when dic["to_s"]
      a = $stack.pop
      $stack <<a.to_s
      return 1
    when dic["stackpr"]
      a = $stack.pop
      puts a
      return 1
    when dic["discard"]
      $stack.pop
      return 1
    when dic["and"]
      b,a = $stack.pop, $stack.pop
      $stack << a&&b
      return 1
    when dic["or"]
      b,a = $stack.pop, $stack.pop
      $stack << a||b
      return 1
    when dic["regex"]
      case src[1,1]
      when "s"
        b,a = $stack.pop, $stack.pop
        /#{a}/ =~ b
        $vardic["$~"]=$~
        $vardic["$&"]=$&
        return 2
      when "/"
        li="/"
        /^(#{li})([^#{li}]*)#{li}([^#{li}]*)#{li}(g?)/ =~ src[1..-1]
        len =$&.length
        if $4!=""
          a =$stack.pop.gsub!(/#{$2}/, $3 )
        else
          a =$stack.pop.sub!(/#{$2}/, $3 )
        end
        $stack <<a
        return 1+len
      else
      end
      return 2
    when dic["eval"]
      $stack <<eval($stack.pop)
      return 1
    when dic["byteeval"]
      $stack <<runbycodeMain($stack.pop, dic)
      return 1
    when dic["block.start"]
      $statestack <<[$vardic.dup, $localvardic.dup]
      $localvardic.keys.each{|k|
        $vardic[k] =$localvardic[k]
      }
      return 1
    when dic["block.end"]
      to=$vardic
      lto=$localvardic
      $vardic={}
      $localvardic={}
      tmp=$statestack.pop
      p tmp[0],tmp[1],to #if $debug
      lto.keys.each{|key|
        if tmp[1].key? key
          $localvardic[key]=lto[key]
        end
      }
      to.keys.each{|key|
        if tmp[0].key? key
          $vardic[key]=to[key]
        end
      }
      return 1
    when dic["thread"]
      li =src[1,1]
      /#{li}([^#{li}]*)#{li}/ =~ src[1..-1]
      newsrc =$1
      th =Thread.start{
        runbycodeMain newsrc, dic
      }
      $thread <<th
      return 1+$&.length
    when dic["thread.end"]
      po =$stack.pop.to_i
      Thread.kill $thread.delete_at(po)
      return 1
    when dic["exec"]
      /(.*)#{src[0,1]}/ =~ src[1..-1]
      $stack <<`#{$1}`
      return 2+$1.length
    when dic["local"]
      return 1 if src[1,1]!=dic["assign"]
      value =$stack.pop
      /([^; \n]*)/ =~ src[2..-1]
      assign($1, value, "local")
      p $localvardic if $debug
      return 3+$1.length
    when dic["assign"]
      value =$stack.pop
      /([^; \n]*)/ =~ src[1..-1]
      assign($1, value)
      p $vardic if $debug
      return 2+$1.length
    when dic["varpush"]
      /([^; \n]*)/ =~ src[1..-1]
      $stack <<getvar($1)
      return 2+$1.length
    when dic["repeat"]
      case src[1,1]
      when "0"
        li=src[2,1]
        /(.)([^#{li}]*)#{li}/ =~ src[2..-1]
        while 1
          runbycodeSub($2,dic)
        end
        return 2+$&.length
      when "1"
        /(.)([^#{li}]*)#{li}([^#{li}]*)#{li}/ =~ src[2..-1]
        rep=$2.to_i
        rep.times{runbycodeSub($3,dic)}
        return 2+$&.length
      else
      end
      return 2
    when dic["if"]
      li=src[2,1]
      case src[1,1]
      when "0"
        /(.)([^#{li}]*)#{li}([^#{li}]*)#{li}/ =~ src[2..-1]
        runbycodeSub($2,dic)
        if $stack.pop
          return $1.length+$2.length+1+2
        end
        return 2+$&.length
      when "1"
        /(.)([^#{li}]*)#{li}([^#{li}]*)#{li}([^#{li}]*)#{li}/ =~ src[2..-1]
        runbycodeSub($2,dic)
        if $stack.pop
          runbycodeSub($3,dic)
        else
          runbycodeSub($4,dic)
        end
        return 2+$&.length
      else
      end
      return 1
    when dic["pair"]
      $pair[src[1,1]]=src[2,1]
      return 3
    when dic["comment"]
      if $uselinecomment
        /^.*$/ =~ src[2..-1]
        return $&.length
      end
      false
    when dic["sys"]
      case src[1,1]
      when "r"
        endm=escaped(pair(src[2,1]))
        /^(.)([^#{endm}]*)#{endm}/ =~ src[2..-1]
        requ =[]
        open($2){|f|
          requ =f.readlines
        }
        requ.each{|i|
          runbycodeSub i,dic
        }
        return 2+$&.length
      when "p"
        $promptf = ! $promptf
      when "h"
        open($helpfile){|h|puts h.readlines}
      else
      end
      return 2
    when dic["halt"]
      exit
    else
      # not yet
      p "non" if $debug
      # print src[0,1]
      return 1
    end
  rescue
    puts "(#{$0}: error!)\n"
    # $stack <<"error"
    return false
  end
end

def runbycodeSub str,dic,pos=0
  puts "!"+str if $debug
  ans =runbycode(str, 0, dic)
  while ans!=false
    if ans.class==String
      case ans[0,1]
      when "c" #call
        $stack <<pos+$addlen+1
        print "stack:" if $debug
        p $stack if $debug
        pos =getjpadd(ans)
      when "j" #jump
        pos =getjpadd(ans)
      when "r" #ret
        pos =$stack.pop
      when "g" #gets
        $mem =$mem[0,$bufadr]+ans[1..-1]+$mem[($bufadr+ans.length-1)..-1]
        p "g",$mem if $debug
        pos +=1
      when "p" #puts
        /(.*)#{ans[1,1]}/ =~ $mem[$bufadr..-1]
        puts $1 if $&
        pos +=2
      else
        p ans if $debug
      end
    elsif ans.class==Array
      if ans[0]=="j"
        pos =ans[1]
      end
      if ans[0]=="label"
        /(#{":"+ans[1]}[ ;\n])(.*)/ =~ $mem
        if $&
          pos=$`.length+$1.length
        else
          pos=0
        end
      end
    else
      pos +=ans
      break if pos<0
    end
    # p str,pos
    ans =runbycode(str, pos, dic)
  end
end

def runbycodeMain str,dic=$dic
  $mem =str
  runbycodeSub str, dic
  print ">" if $promptf
  p "end." if $debug
  $stack
end
