/* **************************************************************************
 * Copyright (C) 2008 BJoRFUAN. All Right Reserved
 * **************************************************************************
 * This module, contains source code, binary and documentation, is in the
 * BSD License, and comes with NO WARRANTY.
 *
 *                                                 torao <torao@bjorfuan.com>
 *                                                       http://www.moyo.biz/
 * $Id: BuilderLexicalHandler.java,v 1.1 2009/04/10 03:48:37 torao Exp $
*/
package org.koiroha.xml.parser;

import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// BuilderLexicalHandler: ビルダー構文ハンドラ
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/**
 * SAX パーサからのコールバックを受けるための {@link LexicalHandler} 拡張インターフェース
 * です。DOM を構築するための追加通知を定義します。
 * <p>
 * @version $Revision: 1.1 $ $Date: 2009/04/10 03:48:37 $
 * @author torao
 * @since 2009/04/01 Java SE 6
 */
interface BuilderLexicalHandler extends LexicalHandler {

	// ======================================================================
	// コメントの開始
	// ======================================================================
	/**
	 * コメントが開始する時に呼び出されます。
	 * <p>
	 * @throws SAXException 呼び出し側により処理を中断する場合
	*/
	public void startComment() throws SAXException;

	// ======================================================================
	// コメントの終了
	// ======================================================================
	/**
	 * コメントが終了する時に呼び出されます。
	 * <p>
	 * @throws SAXException 呼び出し側により処理を中断する場合
	*/
	public void endComment() throws SAXException;

}
