/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.Closeable;
import java.io.IOException;
import java.io.PushbackReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.koiroha.xml.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class Toolkit {
    private static final Logger logger;
    private static final Set<String> EMPTY_ELEMENT;
    private static final Map<String, Set<String>> PARENT_RELATION;
    private static final Set<String> TEXT_DECORATION_ELEMENT;
    private static final Pattern PATTERN_ATTRIBUTE;

    private Toolkit() {
    }

    public static boolean isEmptyElement(String string, String string2, String string3) {
        if (string2 == null) {
            return EMPTY_ELEMENT.contains(string3.toLowerCase());
        }
        return EMPTY_ELEMENT.contains(string2.toLowerCase());
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "fail to close stream", iOException);
            }
        }
    }

    public static String format(String string, Object ... objectArray) throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.koiroha.xml.parser.messages");
        String string2 = resourceBundle.getString(string);
        return String.format(string2, objectArray);
    }

    public static boolean streamStartsWith(PushbackReader pushbackReader, String string, boolean bl) throws IOException {
        assert (string.indexOf(65535) < 0 || string.indexOf(65535) == string.length() - 1) : string;
        assert (string.indexOf(65534) < 0 || string.indexOf(65534) == string.length() - 1) : string;
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            int n = pushbackReader.read();
            if (!Toolkit.matches(string.charAt(i), n, bl)) {
                if (n >= 0) {
                    pushbackReader.unread(n);
                }
                pushbackReader.unread(cArray, 0, i);
                return false;
            }
            cArray[i] = (char)n;
        }
        if (string.charAt(string.length() - 1) != '\uffff') {
            pushbackReader.unread(cArray);
        } else {
            pushbackReader.unread(cArray, 0, cArray.length - 1);
        }
        return true;
    }

    public static boolean matches(char c, int n, boolean bl) {
        if (c == '\u0000') {
            return Xml.isWhitespace(n);
        }
        if (c == '\uffff') {
            return n < 0;
        }
        if (c == '\ufffe') {
            return n >= 0;
        }
        if (bl) {
            return Character.toLowerCase(c) == Character.toLowerCase((char)n);
        }
        return c == n;
    }

    public static Element getPreferredParent(Element element, Element element2) {
        Object object;
        Element element3;
        assert (element != null);
        String string = Toolkit.getName(element2).toLowerCase();
        Set<String> set = PARENT_RELATION.get(string);
        if (set != null) {
            element3 = element;
            object = element3.getParentNode();
            while (true) {
                if (set.contains(Toolkit.getName(element3).toLowerCase())) {
                    return element3;
                }
                if (!(object instanceof Element)) break;
                element3 = (Element)object;
                object = object.getParentNode();
            }
        }
        if (string.equals("p")) {
            element3 = element;
            while (true) {
                if (!TEXT_DECORATION_ELEMENT.contains(object = Toolkit.getName(element3).toLowerCase()) && !((String)object).equals(string)) {
                    return element3;
                }
                if (!(element3.getParentNode() instanceof Element)) break;
                element3 = (Element)element3.getParentNode();
            }
        }
        return element;
    }

    public static String getName(Element element) {
        String string = element.getLocalName();
        if (string == null) {
            string = element.getTagName();
        }
        return string;
    }

    public static Map<String, String> parseAttributesSimply(CharSequence charSequence) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Matcher matcher = PATTERN_ATTRIBUTE.matcher(charSequence);
        while (matcher.find()) {
            String string = matcher.group(1).toLowerCase();
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            if (string2.length() == 0) {
                string3 = string;
            } else {
                if (string3.length() >= 2 && string3.charAt(0) == string3.charAt(string3.length() - 1) && (string3.charAt(0) == '\"' || string3.charAt(0) == '\'')) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                string3 = Xml.unescape(string3);
            }
            hashMap.put(string, string3);
        }
        return hashMap;
    }

    static {
        Object object;
        Object object2;
        logger = Logger.getLogger(Toolkit.class.getName());
        EMPTY_ELEMENT = new HashSet<String>();
        PARENT_RELATION = new HashMap<String, Set<String>>();
        TEXT_DECORATION_ELEMENT = new HashSet<String>();
        PATTERN_ATTRIBUTE = Pattern.compile("([^\\s=]+)\\s*(=?)\\s*(\"[^\"]*\"|'[^']*'|[^\\s]*)");
        String string = "/org/koiroha/xml/parser/html.xml";
        URL uRL = Toolkit.class.getResource(string);
        Document document = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(uRL.toString());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "fail to read resource: " + string, exception);
            throw new IllegalStateException(exception);
        }
        object2 = XPathFactory.newInstance().newXPath();
        try {
            object = (NodeList)object2.evaluate("/html-tag/tag", document, XPathConstants.NODESET);
            for (int i = 0; i < object.getLength(); ++i) {
                String string2;
                Element element = (Element)object.item(i);
                String string3 = element.getAttribute("name");
                String[] stringArray = element.getAttribute("parent").split("\\s+");
                if (stringArray.length > 0) {
                    PARENT_RELATION.put(string3, new HashSet<String>(Arrays.asList(stringArray)));
                }
                if ((string2 = element.getAttribute("style")).equals("empty")) {
                    EMPTY_ELEMENT.add(string3);
                    continue;
                }
                if (string2.equals("decoration")) {
                    TEXT_DECORATION_ELEMENT.add(string3);
                    continue;
                }
                if (string2.length() != 0) assert (false) : "unexpected style " + string3 + ": " + string2;
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

