/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.Serializable;

public final class Position
implements Comparable<Position>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String USERDATA_NAME = "org.koiroha.xml.parser.position";
    private final int lineNumber;
    private final int columnNumber;

    public Position(int n, int n2) {
        assert (n > 0 && n2 > 0) : "invalid position(" + n + "," + n2 + ")";
        this.lineNumber = n;
        this.columnNumber = n2;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int compareTo(Position position) {
        if (this.getLineNumber() > position.getLineNumber()) {
            return 1;
        }
        if (this.getLineNumber() < position.getLineNumber()) {
            return -1;
        }
        if (this.getColumnNumber() > position.getColumnNumber()) {
            return 1;
        }
        if (this.getColumnNumber() < position.getColumnNumber()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.getLineNumber() << 16 | this.getColumnNumber();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Position)) {
            return false;
        }
        Position position = (Position)object;
        return this.getLineNumber() == position.getLineNumber() && this.getColumnNumber() == position.getColumnNumber();
    }

    public String toString() {
        return "(" + this.getLineNumber() + "," + this.getColumnNumber() + ")";
    }
}

