/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.util.Map;
import org.koiroha.xml.DefaultNamespaceContext;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.ext.Attributes2Impl;

class Markup {
    private final Markup parent;
    private final String uri;
    private final String localName;
    private final String qName;
    private final Attributes2Impl attr = new Attributes2Impl();
    private boolean empty;
    private boolean end;
    private final DefaultNamespaceContext namespace;

    public Markup(boolean bl, Markup markup, String string, Map<String, String> map, boolean bl2, boolean bl3) {
        this.parent = markup;
        this.qName = string;
        this.end = bl3;
        this.namespace = markup != null && bl ? new DefaultNamespaceContext(markup.namespace) : new DefaultNamespaceContext();
        this.parseAttribute(bl, map);
        String string2 = "";
        int n = string.indexOf(58);
        if (n < 0 || !bl) {
            this.localName = string;
        } else {
            string2 = string.substring(0, n);
            this.localName = string.substring(n + 1);
        }
        this.uri = this.getNamespaceURI(string2);
        this.empty = bl2 || Toolkit.isEmptyElement(this.uri, this.localName, string);
    }

    public String getUri() {
        return this.uri;
    }

    public String getQName() {
        return this.qName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Attributes2Impl getAttributes() {
        return this.attr;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setEnd(boolean bl) {
        this.end = bl;
    }

    public boolean isEndOf(Markup markup) {
        assert (this.isEnd()) : markup;
        return this.getLocalName().equals(markup.getLocalName());
    }

    public boolean isDisusedEnd(Markup markup) {
        assert (this.isEnd());
        Markup markup2 = markup;
        while (markup2 != null) {
            if (this.isEndOf(markup2)) {
                return false;
            }
            markup2 = markup.parent;
        }
        return true;
    }

    public Markup getParent() {
        return this.parent;
    }

    public String getNamespaceURI(String string) {
        return this.namespace.getNamespaceURI(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("<");
        if (this.isEnd()) {
            stringBuilder.append('/');
        }
        stringBuilder.append(this.getQName());
        for (int i = 0; i < this.attr.getLength(); ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(this.attr.getQName(i)).append("=\"");
            stringBuilder.append(Xml.escape(this.attr.getValue(i))).append("\"");
        }
        if (!this.isEnd() && this.isEmpty()) {
            stringBuilder.append('/');
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    private void parseAttribute(boolean bl, Map<String, String> map) {
        String string;
        String string2;
        String string3;
        if (bl) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                string3 = entry.getKey();
                string2 = entry.getValue();
                if (string3.equals("xmlns")) {
                    this.namespace.setNamespaceURI("", string2);
                    continue;
                }
                if (!string3.startsWith("xmlns:")) continue;
                int n = string3.indexOf(58);
                string = string3.substring(n + 1);
                this.namespace.setNamespaceURI(string, string2);
            }
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string3 = entry.getKey();
            string2 = entry.getValue();
            String string4 = string3;
            string = "";
            if (bl) {
                int n = string3.indexOf(58);
                if (n >= 0) {
                    string4 = string3.substring(n + 1);
                    String string5 = string3.substring(0, n);
                    string = this.getNamespaceURI(string5);
                }
                if (string3.equals("xmlns")) {
                    string = "http://www.w3.org/2000/xmlns/";
                }
            }
            this.attr.addAttribute(string, string4, string3, "CDATA", string2);
        }
    }
}

