/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.AbstractXMLReader;
import org.koiroha.xml.parser.BuilderLexicalHandler;
import org.koiroha.xml.parser.LocatorReader;
import org.koiroha.xml.parser.Markup;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class LooseXMLReader
extends AbstractXMLReader {
    private static final Logger logger = Logger.getLogger(LooseXMLReader.class.getName());
    public static final String FEATURE_LOWERCASE_NAME = "http://www.koiroha.org/sax/futures/html/lowercasename";
    private static final Pattern PATTERN_ATTRIBUTE = Pattern.compile("([^\\s=]+)\\s*(=?)\\s*(\"[^\"]*\"|'[^']*'|[^\\s]*)");
    private ContentHandler contentHandler = null;
    private Markup currentMarkup = null;

    public LooseXMLReader() {
        this(new HashMap<String, Boolean>(), new HashMap<String, Object>());
    }

    public LooseXMLReader(Map<String, Boolean> map, Map<String, Object> map2) {
        super(map, map2);
    }

    public boolean isLowerCaseName() {
        return this.getFeature(FEATURE_LOWERCASE_NAME, true);
    }

    @Override
    protected void handleDocument() throws IOException, SAXException {
        block10: {
            Short s;
            logger.finest("handleDocument(); lowercase=" + this.isLowerCaseName() + "," + "namespace=" + this.isNamespaceAware() + "," + "validation=" + this.isValidating());
            this.contentHandler = this.getContentHandler();
            if (this.contentHandler == null) {
                this.contentHandler = new DefaultHandler2();
            }
            block8: while (true) {
                this.in.markLocation();
                s = this.in.getNextType();
                if (s == null) break block10;
                switch (s) {
                    case 3: {
                        this.handleText();
                        continue block8;
                    }
                    case 4: {
                        this.handleCDATA();
                        continue block8;
                    }
                    case 8: {
                        this.handleComment();
                        continue block8;
                    }
                    case 7: {
                        this.handleProcessingInstruction();
                        continue block8;
                    }
                    case 1: {
                        this.handleElement();
                        continue block8;
                    }
                    case 10: {
                        this.handleDocumentType();
                        continue block8;
                    }
                }
                if (!$assertionsDisabled) break;
            }
            throw new AssertionError(s);
        }
    }

    private void handleElement() throws IOException, SAXException {
        logger.finest("handleElement()");
        Markup markup = this.readElement(this.currentMarkup);
        assert (markup != null);
        String string = markup.getUri();
        String string2 = markup.getLocalName();
        String string3 = markup.getQName();
        if (markup.isEnd()) {
            this.contentHandler.endElement(string, string2, string3);
        } else {
            this.contentHandler.startElement(string, string2, string3, markup.getAttributes());
            if (markup.isEmpty()) {
                this.contentHandler.endElement(string, string2, string3);
            } else if (this.isLanguageElement(string, string2, string3)) {
                logger.finest("recognize text or comment in element: " + markup);
                this.in.setTextModeEnd(string3);
            }
        }
        if (!markup.isEnd() && !markup.isEmpty()) {
            this.currentMarkup = markup;
        } else if (this.currentMarkup != null && markup.isEnd() && this.currentMarkup.getQName().equals(markup.getQName())) {
            this.currentMarkup = this.currentMarkup.getParent();
        }
    }

    private void handleText() throws IOException, SAXException {
        String string;
        if (this.in.isTextMode()) {
            int n = this.in.read();
            if (n == 60) {
                logger.finest("'<' detect in text mode");
                this.contentHandler.characters(new char[]{(char)n}, 0, 1);
            } else {
                this.in.unread(n);
            }
        }
        while ((string = this.read(1024, "<\ufffe", true)) != null) {
            char[] cArray = string.toCharArray();
            this.contentHandler.characters(cArray, 0, cArray.length);
        }
    }

    private void handleCDATA() throws IOException, SAXException {
        String string;
        String string2 = "<![CDATA[";
        String string3 = "]]>";
        this.in.skipSequence(string2, true, true);
        this.getLexicalHandler().startCDATA();
        while ((string = this.read(1024, string3, false)) != null) {
            char[] cArray = string.toCharArray();
            this.contentHandler.characters(cArray, 0, cArray.length);
        }
        this.getLexicalHandler().endCDATA();
        this.in.skipSequence(string3, false);
    }

    private void handleComment() throws IOException, SAXException {
        String string;
        String string2 = "<!--";
        String string3 = "-->";
        this.in.skipSequence(string2, true);
        if (this.getLexicalHandler() instanceof BuilderLexicalHandler) {
            ((BuilderLexicalHandler)this.getLexicalHandler()).startComment();
        }
        char[] cArray = new char[512];
        boolean bl = false;
        char c = '\u0000';
        while ((string = this.read(512, string3, false)) != null) {
            for (int i = 0; i < string.length(); i += cArray.length) {
                int n = Math.min(cArray.length, string.length() - i);
                string.getChars(i, i + n, cArray, 0);
                this.getLexicalHandler().comment(cArray, 0, n);
            }
            if (bl) continue;
            bl = this.checkDoubleHyphen(c, string);
            c = string.charAt(string.length() - 1);
        }
        if (!bl && c == '-') {
            this.warn("C0001", new Object[0]);
        }
        if (this.getLexicalHandler() instanceof BuilderLexicalHandler) {
            ((BuilderLexicalHandler)this.getLexicalHandler()).endComment();
        }
        this.in.skipSequence(string3, false);
    }

    private boolean checkDoubleHyphen(char c, String string) throws SAXException {
        for (int i = 0; i < string.length(); ++i) {
            if (c == '-' && string.charAt(i) == '-') {
                this.warn("C0001", new Object[0]);
                return true;
            }
            c = string.charAt(i);
        }
        return false;
    }

    private void handleProcessingInstruction() throws IOException, SAXException {
        String string = "<?";
        String string2 = "?>";
        this.in.skipSequence(string, true);
        String string3 = this.read(Integer.MAX_VALUE, string2, false);
        if (string3 == null) {
            string3 = "";
        }
        String string4 = "";
        for (int i = 0; i < string3.length(); ++i) {
            if (!Xml.isWhitespace(string3.charAt(i))) continue;
            int n = i;
            while (i + 1 < string3.length() && Xml.isWhitespace(string3.charAt(i + 1))) {
                ++i;
            }
            string4 = string3.substring(i + 1);
            string3 = string3.substring(0, n);
            break;
        }
        if (string3.equalsIgnoreCase("xml")) {
            this.handleXMLDeclaration(string4);
        } else {
            this.contentHandler.processingInstruction(string3, string4);
        }
        this.in.skipSequence(string2, false);
    }

    private void handleXMLDeclaration(String string) throws SAXException {
        Map<String, String> map = Toolkit.parseAttributesSimply(string);
        String string2 = map.get("version");
        String string3 = map.get("encoding");
        if (string2 == null) {
            string2 = "1.0";
        }
        this.in.setXmlVersion(string2);
        this.in.setEncoding(string3);
        this.setProperty("http://xml.org/sax/properties/document-xml-version", string2);
        logger.finest("xml declaration detected: version=" + string2 + ", encoding=" + string3);
        map.remove("version");
        map.remove("encoding");
        map.remove("standalone");
        for (String string4 : map.keySet()) {
            this.warn("X0001", string4, Xml.escape(map.get(string4)));
        }
    }

    private void handleDocumentType() throws IOException, SAXException {
        String string = ">";
        this.in.skipSequence("<!DOCTYPE\u0000", true, true);
        String string2 = this.read(Integer.MAX_VALUE, string, false);
        if (string2 == null) {
            string2 = "";
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray = new String[]{"([^\\s]+)\\s+PUBLIC\\s+[\"']([^\"]*)[\"']\\s*[\"']([^\"]*)[\"']\\s*", "([^\\s]+)\\s+PUBLIC\\s+[\"']([^\"]*)[\"']()\\s*", "([^\\s]+)\\s+SYSTEM\\s+()[\"']([^\"]*)[\"']\\s*", "([^\\s]+)\\s*()()"};
        for (int i = 0; i < stringArray.length; ++i) {
            Pattern pattern = Pattern.compile(stringArray[i], 2);
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) continue;
            string3 = matcher.group(1);
            string4 = matcher.group(2);
            string5 = matcher.group(3);
            break;
        }
        logger.finest("dtd: " + string3 + ",publicId=" + string4 + ",systemId=" + string5);
        if (string3 == null) {
            this.warn("D0001", string2);
        } else if (this.getDTDHandler() != null) {
            if (this.isLowerCaseName()) {
                string3 = string3.toLowerCase();
            }
            this.getDTDHandler().notationDecl(string3, string4, string5);
        }
        this.in.skipSequence(string, false);
    }

    private String read(int n, String string, boolean bl) throws IOException, SAXException {
        return this.read(this.in, n, string, bl);
    }

    private String read(PushbackReader pushbackReader, int n, String string, boolean bl) throws IOException, SAXException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        while (!(string != null && Toolkit.streamStartsWith(pushbackReader, string, false) || stringBuilder.length() >= n || (n2 = pushbackReader.read()) < 0)) {
            if (n2 == 65279) continue;
            if (n2 == 13) {
                stringBuilder.append('\n');
                n2 = pushbackReader.read();
                if (n2 < 0) break;
                if (n2 == 10) continue;
                pushbackReader.unread(n2);
                continue;
            }
            if (n2 == 38 && bl) {
                String string2;
                if (pushbackReader instanceof LocatorReader) {
                    pushbackReader.unread(38);
                    ((LocatorReader)pushbackReader).markLocation();
                    pushbackReader.read();
                }
                if ((string2 = this.readEntityReference(pushbackReader)) == null) {
                    stringBuilder.append('&');
                    continue;
                }
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append((char)n2);
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private Markup readElement(Markup markup) throws IOException, SAXException {
        return this.readElement(this.in, this.isLowerCaseName(), markup);
    }

    private Markup readElement(PushbackReader pushbackReader, boolean bl, Markup markup) throws IOException, SAXException {
        Object object;
        Object object2;
        int n = pushbackReader.read();
        assert (n == 60);
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n2;
            if ((n2 = pushbackReader.read()) < 0) {
                assert (stringBuilder.length() > 0);
                break;
            }
            if (n2 == 62) break;
            stringBuilder.append((char)n2);
        }
        String string = stringBuilder.toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("(" + this.in.getLineNumber() + "," + this.in.getColumnNumber() + ") read element body: <" + string + ">");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.startsWith("/")) {
            bl2 = true;
            string = string.substring(1);
        } else if (string.endsWith("/")) {
            bl3 = true;
            string = string.substring(0, string.length() - 1);
        }
        String string2 = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Xml.isWhitespace(c)) continue;
            string2 = string.substring(0, i);
            string = string.substring(i + 1).trim();
            break;
        }
        if (string2 == null) {
            string2 = string;
            string = "";
        }
        if (bl) {
            string2 = string2.toLowerCase();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Matcher matcher = PATTERN_ATTRIBUTE.matcher(string);
        while (matcher.find()) {
            object2 = matcher.group(1);
            if (bl) {
                object2 = ((String)object2).toLowerCase();
            }
            String string3 = matcher.group(2);
            object = matcher.group(3);
            if (string3.length() == 0) {
                object = object2;
            } else if (((String)object).length() >= 2 && ((String)object).charAt(0) == '\"' && ((String)object).charAt(((String)object).length() - 1) == '\"') {
                object = ((String)object).substring(1, ((String)object).length() - 1);
                object = this.parseEntityReference((String)object);
            } else if (((String)object).length() >= 2 && ((String)object).charAt(0) == '\'' && ((String)object).charAt(((String)object).length() - 1) == '\'') {
                object = ((String)object).substring(1, ((String)object).length() - 1);
                object = this.parseEntityReference((String)object);
            } else {
                object = this.parseEntityReference((String)object);
            }
            linkedHashMap.put((String)object2, (String)object);
        }
        object2 = new Markup(this.isNamespaceAware(), markup, string2, linkedHashMap, bl3, bl2);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("parse new element: " + object2);
        }
        if (((Markup)object2).isEnd() && !((Markup)object2).isEmpty() && ((Markup)object2).getAttributes().getLength() > 0) {
            this.warn("E0001", ((Markup)object2).getQName());
            ((Markup)object2).getAttributes().clear();
        }
        if (this.isNamespaceAware()) {
            for (int i = 0; i < ((Markup)object2).getAttributes().getLength(); ++i) {
                object = ((Markup)object2).getAttributes().getQName(i);
                int n3 = ((String)object).indexOf(58);
                if (n3 < 0) continue;
                String string4 = ((String)object).substring(0, n3);
                String string5 = ((Markup)object2).getAttributes().getURI(i);
                if (!string5.equals("")) continue;
                this.warn("E0007", string4);
            }
        }
        return object2;
    }

    private String parseEntityReference(String string) throws SAXException, IOException {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        PushbackReader pushbackReader = new PushbackReader(new StringReader(string), 64);
        while ((string2 = this.read(pushbackReader, 1024, null, true)) != null) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private String readEntityReference(PushbackReader pushbackReader) throws IOException, SAXException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while (stringBuilder.length() < this.getMaxEntityReferenceName() && (n = pushbackReader.read()) >= 0) {
            if (n == 59) {
                String string = this.getEntityReference(stringBuilder.toString());
                if (string == null) {
                    this.warn("T0100", stringBuilder);
                    stringBuilder.append((char)n);
                    pushbackReader.unread(stringBuilder.toString().toCharArray());
                    return null;
                }
                return string;
            }
            stringBuilder.append((char)n);
        }
        this.warn("T0001", stringBuilder);
        if (stringBuilder.length() > 0) {
            pushbackReader.unread(stringBuilder.toString().toCharArray());
        }
        return null;
    }

    protected boolean isLanguageElement(String string, String string2, String string3) {
        return false;
    }

    private void warn(String string, Object ... objectArray) throws SAXException {
        if (this.getErrorHandler() != null) {
            String string2 = string + ":" + Toolkit.format("warn." + string, objectArray);
            logger.finest("warn(): " + string2);
            SAXParseException sAXParseException = new SAXParseException(string2, this.in.getPublicId(), this.in.getSystemId(), this.in.getLineNumber(), this.in.getColumnNumber());
            this.getErrorHandler().warning(sAXParseException);
        }
    }
}

