/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.LFReader;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.ext.Locator2;

public class LocatorReader
extends PushbackReader
implements Locator2 {
    private final String publicId;
    private final String systemId;
    private String xmlVersion = null;
    private String encoding = null;
    private int currentLine = 1;
    private int currentColumn = 1;
    private int line = 1;
    private int column = 1;
    private String textModeEnd = null;

    LocatorReader(Reader reader, String string, String string2) {
        super(new LFReader(reader), 64);
        this.publicId = string;
        this.systemId = string2;
    }

    public void markLocation() {
        assert (this.currentLine > 0 && this.currentColumn > 0) : "(" + this.currentLine + "," + this.currentColumn + ")";
        this.line = this.currentLine;
        this.column = this.currentColumn;
    }

    @Override
    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(String string) {
        this.xmlVersion = string;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public int getColumnNumber() {
        return this.column;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n < 0) {
            return n;
        }
        assert (n != 13);
        if (n == 10) {
            ++this.currentLine;
            this.currentColumn = 1;
            return 10;
        }
        ++this.currentColumn;
        return n;
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        for (int i = 0; i < n3; ++i) {
            if (cArray[i] == '\n') {
                ++this.currentLine;
                this.currentColumn = 1;
                continue;
            }
            ++this.currentColumn;
        }
        return n3;
    }

    @Override
    public void unread(int n) throws IOException {
        super.unread(n);
        if (n == 10) {
            --this.currentLine;
            this.currentColumn = 1;
        } else if (this.currentColumn > 1) {
            --this.currentColumn;
        }
    }

    @Override
    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    @Override
    public void unread(char[] cArray, int n, int n2) throws IOException {
        for (int i = n2 - 1; i >= 0; --i) {
            this.unread(cArray[n + i]);
        }
    }

    public boolean isEOF() throws IOException {
        int n = this.read();
        if (n < 0) {
            return true;
        }
        this.unread(n);
        return false;
    }

    public Short getNextType() throws IOException {
        if (this.isEOF()) {
            return null;
        }
        if (!this.startsWith("<") || this.startsWith("<\uffff")) {
            return (short)3;
        }
        if (this.startsWith("<!--")) {
            return (short)8;
        }
        if (this.startsWith("<![CDATA[", true)) {
            return (short)4;
        }
        if (this.textModeEnd != null) {
            if (!this.startsWith("</" + this.textModeEnd + ">", true)) {
                return (short)3;
            }
            this.textModeEnd = null;
        }
        if (this.startsWith("<?")) {
            return (short)7;
        }
        if (this.startsWith("<!DOCTYPE\u0000", true)) {
            return (short)10;
        }
        return (short)1;
    }

    public void setTextModeEnd(String string) {
        this.textModeEnd = string;
    }

    public boolean isTextMode() {
        return this.textModeEnd != null;
    }

    public boolean startsWith(String string) throws IOException {
        return this.startsWith(string, false);
    }

    public boolean startsWith(String string, boolean bl) throws IOException {
        return Toolkit.streamStartsWith(this, string, bl);
    }

    public String skipSequence(String string, boolean bl) throws IOException {
        return this.skipSequence(string, bl, false);
    }

    public String skipSequence(String string, boolean bl, boolean bl2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            int n = this.read();
            assert (!bl || Toolkit.matches(string.charAt(i), n, bl2)) : string + "[" + i + "] != " + (char)n;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public void skipWhitespace() throws IOException {
        int n;
        while ((n = this.read()) >= 0) {
            if (Xml.isWhitespace(n)) continue;
            this.unread(n);
            break;
        }
    }
}

