/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

class LFReader
extends FilterReader {
    private boolean skipLF = false;

    public LFReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == 10 && this.skipLF) {
            n = super.read();
            this.skipLF = false;
        }
        if (n == 13) {
            n = 10;
            this.skipLF = true;
        } else {
            this.skipLF = false;
        }
        return n;
    }

    @Override
    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        do {
            int n4;
            if ((n4 = super.read(cArray, n, n2)) < 0) {
                return n4;
            }
            int n5 = 0;
            n3 = 0;
            if (this.skipLF && cArray[n] == '\n') {
                ++n5;
            }
            this.skipLF = false;
            while (n5 + 1 < n4) {
                if (cArray[n + n5] != '\r') {
                    cArray[n + n3] = cArray[n + n5];
                    ++n3;
                } else if (cArray[n + n5 + 1] != '\n') {
                    cArray[n + n3] = 10;
                    ++n3;
                }
                ++n5;
            }
            if (n5 >= n4) continue;
            int n6 = cArray[n + n4 - 1];
            if (n6 == 13) {
                n6 = 10;
                this.skipLF = true;
            }
            cArray[n + n3] = n6;
            ++n3;
        } while (n3 == 0);
        return n3;
    }
}

