/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.AbstractSAXParserFactory;
import org.koiroha.xml.parser.HTMLParser;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.SAXException;

public class HTMLParserFactory
extends AbstractSAXParserFactory {
    private static final Logger logger = Logger.getLogger(HTMLParserFactory.class.getName());

    public HTMLParserFactory() {
        this.setLowerCaseName(true);
    }

    public void setLowerCaseName(boolean bl) {
        try {
            this.setFeature("http://www.koiroha.org/sax/futures/html/lowercasename", bl);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException);
        }
    }

    public boolean isLowerCaseName() {
        try {
            return this.getFeature("http://www.koiroha.org/sax/futures/html/lowercasename");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException);
        }
    }

    @Override
    public SAXParser newSAXParser() {
        HTMLParser hTMLParser = new HTMLParser(this.feature, this.isXIncludeAware(), this.getSchema());
        return hTMLParser;
    }

    @Override
    protected String guessEncodingFromPrereadSampling(String string) {
        String string2 = super.guessEncodingFromPrereadSampling(string);
        if (string2 != null) {
            return string2;
        }
        Pattern pattern = Pattern.compile("<meta\\s+([^>]*)/?>", 34);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            Charset charset;
            String string3 = matcher.group(1);
            Map<String, String> map = Toolkit.parseAttributesSimply(string3);
            String string4 = map.get("http-equiv");
            String string5 = map.get("content");
            if (string4 == null || !string4.toLowerCase().equals("content-type") || string5 == null || (charset = Xml.getCharset(string5)) == null) continue;
            return charset.name();
        }
        logger.finest("meta element with http-quiv=\"content-type\" is not specified, or charset attribute unrecognized");
        return null;
    }
}

