/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.koiroha.xml.parser.HTMLDocumentBuilder;
import org.koiroha.xml.parser.HTMLParserFactory;
import org.xml.sax.InputSource;

public class HTMLDocumentBuilderFactory
extends DocumentBuilderFactory {
    private static final Logger logger = Logger.getLogger(HTMLDocumentBuilderFactory.class.getName());
    public static final String FEATURE_HTML_OPTIMIZE = "http://www.koiroha.org/sax/features/htmloptimize";
    static final String FEATURE_LOWERCASE_NAME = "http://www.koiroha.org/sax/futures/html/lowercasename";
    static final String FEATURE_COALESCING = "http://www.koiroha.org/sax/features/coalescing";
    static final String FEATURE_IGNORE_COMMENT = "http://www.koiroha.org/sax/features/ignorecomment";
    private final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final DocumentBuilderFactory factory;

    public HTMLDocumentBuilderFactory() {
        this(DocumentBuilderFactory.newInstance());
    }

    public HTMLDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.factory = documentBuilderFactory;
        this.setLowerCaseName(true);
        this.setHtmlOptimize(false);
    }

    @Override
    public Object getAttribute(String string) throws IllegalArgumentException {
        return this.factory.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        this.factory.setAttribute(string, object);
    }

    @Override
    public boolean getFeature(String string) {
        Boolean bl = this.feature.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public void setFeature(String string, boolean bl) {
        logger.finest("setFeature(" + string + "," + bl + ")");
        this.feature.put(string, bl);
    }

    public void setLowerCaseName(boolean bl) {
        this.setFeature(FEATURE_LOWERCASE_NAME, bl);
    }

    public boolean isLowerCaseName() {
        return this.getFeature(FEATURE_LOWERCASE_NAME);
    }

    public void setHtmlOptimize(boolean bl) {
        this.setFeature(FEATURE_HTML_OPTIMIZE, bl);
    }

    public boolean isHtmlOptimize() {
        return this.getFeature(FEATURE_HTML_OPTIMIZE);
    }

    @Override
    public void setCoalescing(boolean bl) {
        this.setFeature(FEATURE_COALESCING, bl);
        this.factory.setCoalescing(bl);
    }

    @Override
    public boolean isCoalescing() {
        return this.factory.isCoalescing();
    }

    @Override
    public void setExpandEntityReferences(boolean bl) {
        this.factory.setExpandEntityReferences(bl);
    }

    @Override
    public boolean isExpandEntityReferences() {
        return this.factory.isExpandEntityReferences();
    }

    @Override
    public void setIgnoringComments(boolean bl) {
        this.setFeature(FEATURE_IGNORE_COMMENT, bl);
        this.factory.setIgnoringComments(bl);
    }

    @Override
    public boolean isIgnoringComments() {
        return this.factory.isIgnoringComments();
    }

    @Override
    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.factory.setIgnoringElementContentWhitespace(bl);
    }

    @Override
    public boolean isIgnoringElementContentWhitespace() {
        return this.factory.isIgnoringElementContentWhitespace();
    }

    @Override
    public void setNamespaceAware(boolean bl) {
        this.setFeature("http://xml.org/sax/features/namespaces", bl);
        this.factory.setNamespaceAware(bl);
    }

    @Override
    public boolean isNamespaceAware() {
        return this.factory.isNamespaceAware();
    }

    @Override
    public void setSchema(Schema schema) {
        this.factory.setSchema(schema);
    }

    @Override
    public Schema getSchema() {
        return this.factory.getSchema();
    }

    @Override
    public void setValidating(boolean bl) {
        this.setFeature("http://xml.org/sax/features/validation", bl);
        this.factory.setValidating(bl);
    }

    @Override
    public boolean isValidating() {
        return this.factory.isValidating();
    }

    @Override
    public void setXIncludeAware(boolean bl) {
        this.factory.setXIncludeAware(bl);
    }

    @Override
    public boolean isXIncludeAware() {
        return this.factory.isXIncludeAware();
    }

    @Override
    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return new HTMLDocumentBuilder(this.factory.newDocumentBuilder(), this.feature);
    }

    public InputSource guessInpuSource(InputStream inputStream, String string, int n) throws IOException {
        return new HTMLParserFactory().guessInpuSource(inputStream, string, n);
    }
}

