/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.SAXParser;
import org.koiroha.xml.parser.HTMLBuilder;
import org.koiroha.xml.parser.HTMLParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class HTMLDocumentBuilder
extends DocumentBuilder {
    private final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final DocumentBuilder builder;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;

    public HTMLDocumentBuilder(DocumentBuilder documentBuilder, Map<String, Boolean> map) {
        this.builder = documentBuilder;
        this.feature.putAll(map);
    }

    public boolean getFeature(String string) {
        Boolean bl = this.feature.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.builder.getDOMImplementation();
    }

    @Override
    public boolean isNamespaceAware() {
        return this.builder.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.builder.isValidating();
    }

    @Override
    public Document newDocument() {
        return this.builder.newDocument();
    }

    @Override
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        HTMLParserFactory hTMLParserFactory = new HTMLParserFactory();
        hTMLParserFactory.setNamespaceAware(this.builder.isNamespaceAware());
        hTMLParserFactory.setValidating(this.builder.isValidating());
        hTMLParserFactory.setXIncludeAware(this.builder.isXIncludeAware());
        hTMLParserFactory.setSchema(this.builder.getSchema());
        hTMLParserFactory.setLowerCaseName(this.getFeature("http://www.koiroha.org/sax/futures/html/lowercasename"));
        SAXParser sAXParser = hTMLParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        if (this.errorHandler != null) {
            xMLReader.setErrorHandler(this.errorHandler);
        }
        if (this.entityResolver != null) {
            xMLReader.setEntityResolver(this.entityResolver);
        }
        assert (sAXParser.isNamespaceAware() == this.builder.isNamespaceAware());
        assert (sAXParser.isValidating() == this.builder.isValidating());
        assert (sAXParser.isXIncludeAware() == this.builder.isXIncludeAware());
        HTMLBuilder hTMLBuilder = new HTMLBuilder(this.builder, this.entityResolver, this.errorHandler, this.feature);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", hTMLBuilder);
        xMLReader.setContentHandler(hTMLBuilder);
        xMLReader.setDTDHandler(hTMLBuilder);
        xMLReader.parse(inputSource);
        return hTMLBuilder.getDocument();
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

