/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import org.koiroha.xml.Xml;
import org.koiroha.xml.parser.BuilderLexicalHandler;
import org.koiroha.xml.parser.HTMLInvocationHandler;
import org.koiroha.xml.parser.Position;
import org.koiroha.xml.parser.Toolkit;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.Locator2;

class HTMLBuilder
extends DefaultHandler2
implements BuilderLexicalHandler {
    private static final Logger logger = Logger.getLogger(HTMLBuilder.class.getName());
    private final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final DocumentBuilder builder;
    private final ErrorHandler errorHandler;
    private Document doc = null;
    private Element current = null;
    private StringBuilder cdata = null;
    private StringBuilder comment = null;
    private Locator2 locator = null;
    private StringBuilder epilogue = null;

    public HTMLBuilder(DocumentBuilder documentBuilder, EntityResolver entityResolver, ErrorHandler errorHandler, Map<String, Boolean> map) {
        this.builder = documentBuilder;
        this.errorHandler = errorHandler;
        this.feature.putAll(map);
    }

    public boolean getFeature(String string) {
        Boolean bl = this.feature.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    private boolean isHtmlOptimize() {
        return this.getFeature("http://www.koiroha.org/sax/features/htmloptimize");
    }

    private boolean isCoalescing() {
        return this.getFeature("http://www.koiroha.org/sax/features/coalescing");
    }

    private boolean isIgnoringComments() {
        return this.getFeature("http://www.koiroha.org/sax/features/ignorecomment");
    }

    private boolean isNamespaceAware() {
        return this.getFeature("http://xml.org/sax/features/namespaces");
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = (Locator2)locator;
    }

    @Override
    public void startDocument() {
        logger.finest("startDocument(); namespace=" + this.isNamespaceAware() + "," + "xinclude=" + this.builder.isXIncludeAware() + "," + "validation=" + this.builder.isValidating());
        this.doc = this.builder.newDocument();
    }

    @Override
    public void endDocument() {
        String string;
        logger.finest("endDocument()");
        assert (this.cdata == null) : this.cdata;
        assert (this.comment == null) : this.comment;
        if (this.epilogue != null && this.epilogue.length() > 0) {
            assert (this.doc.getDocumentElement() != null);
            string = this.epilogue.toString();
            string = HTMLBuilder.trimRight(string);
            this.doc.getDocumentElement().appendChild(this.doc.createTextNode(string));
        }
        if ((string = this.locator.getXMLVersion()) != null) {
            this.doc.setXmlVersion(string);
        }
        HTMLInvocationHandler hTMLInvocationHandler = new HTMLInvocationHandler(this.doc);
        hTMLInvocationHandler.setInputEncoding(this.locator.getEncoding());
        this.doc = (Document)Proxy.newProxyInstance(HTMLBuilder.class.getClassLoader(), new Class[]{Document.class}, (InvocationHandler)hTMLInvocationHandler);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Object object2;
        logger.finest("startElement(" + string + "," + string2 + "," + string3 + ",attrs)");
        Element element = null;
        try {
            element = this.isNamespaceAware() ? this.doc.createElementNS(string, string3) : this.doc.createElement(string3);
        }
        catch (DOMException dOMException) {
            logger.finest(dOMException.toString());
            if (dOMException.code == 5) {
                this.warn("E0005", string3);
            } else {
                this.warn("E9999", dOMException.getMessage());
            }
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            object2 = attributes.getURI(i);
            object = attributes.getQName(i);
            String string4 = attributes.getValue(i);
            logger.finest("setAttributeNS(" + (String)object2 + "," + (String)object + "," + string4 + ")");
            try {
                if (this.isNamespaceAware()) {
                    element.setAttributeNS((String)object2, (String)object, string4);
                    continue;
                }
                element.setAttribute((String)object, string4);
                continue;
            }
            catch (DOMException dOMException) {
                logger.finest(dOMException.toString());
                if (dOMException.code == 5) {
                    this.warn("E0006", object, Xml.escape(string4));
                    continue;
                }
                this.warn("E9999", dOMException.getMessage());
            }
        }
        if (string2.equalsIgnoreCase("html")) {
            if (this.doc.getDocumentElement() == null) {
                this.doc.appendChild(element);
                logger.finest("html element detected");
            } else {
                Element element2 = this.doc.getDocumentElement();
                while (element2.getFirstChild() != null) {
                    object2 = element2.removeChild(element2.getFirstChild());
                    element.appendChild((Node)object2);
                }
                this.doc.removeChild(element2);
                this.doc.appendChild(element);
                logger.finest("replace html element");
            }
        } else {
            if (this.current != null && this.isHtmlOptimize()) {
                object2 = this.current;
                Element element3 = Toolkit.getPreferredParent(this.current, element);
                if (object2 != element3) {
                    this.warn("E0008", object2.getTagName());
                    do {
                        object = (Position)object2.getUserData("org.koiroha.xml.parser.position");
                        this.warn((Position)object, "E0004", object2.getTagName());
                    } while ((object2 = (Element)object2.getParentNode()) != element3);
                }
                this.current = element3;
            }
            this.appendNode(element);
        }
        if (!Toolkit.isEmptyElement(string, string2, string3)) {
            this.current = element;
            logger.finest("current element pointer set to <" + string3 + ">");
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        logger.finest("endElement(" + string + "," + string2 + "," + string3 + ")");
        if (Toolkit.isEmptyElement(string, string2, string3)) {
            logger.finest("ignore end of empty element");
            this.checkEmptyElementEnd(string, string2, string3);
            return;
        }
        Element element = this.search(string3);
        if (element == null) {
            this.warn("E0002", string3);
            return;
        }
        for (Element element2 = this.current; element2 != element; element2 = (Element)element2.getParentNode()) {
            Position position = (Position)element2.getUserData("org.koiroha.xml.parser.position");
            this.warn(position, "E0004", element2.getTagName());
        }
        if (element.getParentNode() instanceof Element) {
            this.current = (Element)element.getParentNode();
            logger.finest("move current elemnt to <" + this.current.getTagName() + ">");
        } else {
            this.current = null;
            this.epilogue = new StringBuilder();
            logger.finest("end document element, start epilogue");
        }
    }

    private void checkEmptyElementEnd(String string, String string2, String string3) throws SAXException {
        if (this.current == null) {
            this.warn("E0002", string3);
            return;
        }
        Node node = this.current.getLastChild();
        while (node instanceof Text && ((Text)node).getData().trim().length() == 0) {
            node = node.getPreviousSibling();
        }
        if (!(node instanceof Element)) {
            this.warn("E0002", string3);
            return;
        }
        Element element = (Element)node;
        if (this.isNamespaceAware()) {
            if (!element.getLocalName().equals(string2)) {
                this.warn("E0002", string3);
            }
        } else if (!element.getTagName().equals(string3)) {
            this.warn("E0002", string3);
        }
    }

    @Override
    public void startCDATA() {
        logger.finest("startCDATA()");
        if (!this.isCoalescing()) {
            this.cdata = new StringBuilder();
        }
    }

    @Override
    public void endCDATA() {
        logger.finest("endCDATA(): <![CDATA[" + this.cdata + "]]>");
        CDATASection cDATASection = this.doc.createCDATASection(this.cdata.toString());
        this.appendNode(cDATASection);
        this.cdata = null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        logger.finest("characters(ch," + n + "," + n2 + ")");
        if (this.cdata != null) {
            this.cdata.append(cArray, n, n2);
            return;
        }
        Text text = this.doc.createTextNode(new String(cArray, n, n2));
        this.appendNode(text);
    }

    @Override
    public void startComment() throws SAXException {
        if (!this.isIgnoringComments()) {
            this.comment = new StringBuilder();
        }
    }

    @Override
    public void endComment() throws SAXException {
        logger.finest("endComment(): <!--" + this.comment + "-->");
        if (!this.isIgnoringComments()) {
            Comment comment = this.doc.createComment(this.comment.toString());
            this.appendNode(comment);
            this.comment = null;
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) {
        if (!this.isCoalescing()) {
            this.comment.append(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        logger.finest("processingInstruction(" + string + "," + string2 + ")");
        try {
            ProcessingInstruction processingInstruction = this.doc.createProcessingInstruction(string, string2);
            this.appendNode(processingInstruction);
        }
        catch (DOMException dOMException) {
            logger.fine(dOMException.toString());
            this.warn("P0001", string);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        logger.finest("notationDecl(" + string + "," + string2 + "," + string3 + ")");
        DOMImplementation dOMImplementation = this.doc.getImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(string, string2, string3);
        if (this.doc.getDoctype() != null) {
            this.warn("D0002", string, string2, string3);
            return;
        }
        this.doc.insertBefore(documentType, this.doc.getFirstChild());
    }

    private void appendNode(Node node) {
        Position position = new Position(this.locator.getLineNumber(), this.locator.getColumnNumber());
        node.setUserData("org.koiroha.xml.parser.position", position, null);
        if (this.current != null) {
            this.current.appendChild(node);
            return;
        }
        if (node instanceof ProcessingInstruction || node instanceof Comment || node instanceof DocumentType) {
            logger.finest("append node to document directlly");
            this.doc.appendChild(node);
            return;
        }
        if (this.doc.getDocumentElement() == null) {
            Object object;
            if (node.getNodeType() == 3) {
                object = ((Text)node).getData();
                if (((String)(object = HTMLBuilder.trimLeft((String)object))).length() == 0) {
                    logger.finest("fully whitespace characters in prologue is ignored");
                    return;
                }
                node = this.doc.createTextNode((String)object);
                logger.finest("text in prologue: \"" + (String)object + "\"");
            }
            object = this.doc.createElementNS("", "html");
            this.doc.appendChild((Node)object);
            object.appendChild(node);
            this.current = object;
            logger.finest("create html element implicitly because appearance of node for element");
            assert (object.getLocalName() != null) : object;
            return;
        }
        logger.finest("evaluating epilogue node...");
        assert (this.epilogue != null);
        Element element = this.doc.getDocumentElement();
        if (node.getNodeType() == 3) {
            String string = ((Text)node).getData();
            this.epilogue.append(string);
            return;
        }
        if (this.epilogue.length() > 0) {
            element.appendChild(this.doc.createTextNode(this.epilogue.toString()));
            this.epilogue.setLength(0);
        }
        element.appendChild(node);
    }

    private Element search(String string) {
        if (this.current == null) {
            return null;
        }
        Element element = this.current;
        while (true) {
            if (element.getTagName().equals(string)) {
                return element;
            }
            if (!(element.getParentNode() instanceof Element)) break;
            element = (Element)element.getParentNode();
        }
        return null;
    }

    private static String trimLeft(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Xml.isWhitespace(string.charAt(i))) continue;
            return string.substring(i);
        }
        return "";
    }

    private static String trimRight(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Xml.isWhitespace(string.charAt(i))) continue;
            return string.substring(0, i + 1);
        }
        return "";
    }

    private void warn(String string, Object ... objectArray) throws SAXException {
        this.warn(null, string, objectArray);
    }

    private void warn(Position position, String string, Object ... objectArray) throws SAXException {
        if (this.errorHandler != null) {
            if (position == null) {
                position = new Position(this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
            String string2 = string + ":" + Toolkit.format("warn." + string, objectArray);
            SAXParseException sAXParseException = new SAXParseException(string2, this.locator.getPublicId(), this.locator.getSystemId(), position.getLineNumber(), position.getColumnNumber());
            this.errorHandler.warning(sAXParseException);
        }
    }
}

