/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class AttributeOrderKeeper
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Method GET_ATTRIBUTES;
    private static final Method SET_ATTRIBUTE;
    private static final Method SET_ATTRIBUTE_NS;
    private static final Method SET_ATTRIBUTE_NODE;
    private static final Method SET_ATTRIBUTE_NODE_NS;
    private static final Method REMOVE_ATTRIBUTE;
    private static final Method REMOVE_ATTRIBUTE_NS;
    private static final Method REMOVE_ATTRIBUTE_NODE;
    private static final Method ITEM;
    private final Element elem;
    private final NamedNodeMap attr;
    private final List<String> names;

    public AttributeOrderKeeper(Element element) {
        this.elem = element;
        this.attr = null;
        this.names = new ArrayList<String>();
    }

    public AttributeOrderKeeper(NamedNodeMap namedNodeMap, List<String> list) {
        this.elem = null;
        this.attr = namedNodeMap;
        this.names = list;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (object instanceof Element) {
            return this.invokeElement(object, method, objectArray);
        }
        return this.invokeNamedNodeMap(object, method, objectArray);
    }

    private Object invokeElement(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.equals(GET_ATTRIBUTES)) {
            NamedNodeMap namedNodeMap = this.elem.getAttributes();
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{NamedNodeMap.class, Serializable.class}, (InvocationHandler)new AttributeOrderKeeper(namedNodeMap, this.names));
        }
        if (method.equals(SET_ATTRIBUTE)) {
            String string = (String)objectArray[0];
            if (!this.names.contains(string)) {
                this.names.add(string);
            }
            return method.invoke((Object)this.elem, objectArray);
        }
        if (method.equals(SET_ATTRIBUTE_NS)) {
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            string2 = string + '\u0000' + string2;
            if (!this.names.contains(string2)) {
                this.names.add(string2);
            }
            return method.invoke((Object)this.elem, objectArray);
        }
        if (method.equals(SET_ATTRIBUTE_NODE)) {
            Attr attr = (Attr)objectArray[0];
            String string = attr.getName();
            if (!this.names.contains(string)) {
                this.names.add(string);
            }
            return method.invoke((Object)this.elem, objectArray);
        }
        if (method.equals(SET_ATTRIBUTE_NODE_NS)) {
            Attr attr = (Attr)objectArray[0];
            String string = attr.getNamespaceURI();
            String string3 = attr.getLocalName();
            string3 = string + '\u0000' + string3;
            if (!this.names.contains(string3)) {
                this.names.add(string3);
            }
            return method.invoke((Object)this.elem, objectArray);
        }
        if (method.equals(REMOVE_ATTRIBUTE)) {
            String string = (String)objectArray[0];
            this.names.remove(string);
            return method.invoke((Object)this.elem, objectArray);
        }
        if (method.equals(REMOVE_ATTRIBUTE_NS)) {
            String string = (String)objectArray[0];
            String string4 = (String)objectArray[1];
            string4 = string + '\u0000' + string4;
            this.names.remove(string4);
            return method.invoke((Object)this.elem, objectArray);
        }
        if (method.equals(REMOVE_ATTRIBUTE_NODE)) {
            Attr attr = (Attr)objectArray[0];
            String string = attr.getName();
            if (attr.getNamespaceURI() != null) {
                string = attr.getNamespaceURI() + '\u0000' + attr.getLocalName();
            }
            this.names.remove(string);
            return method.invoke((Object)this.elem, objectArray);
        }
        return method.invoke((Object)this.elem, objectArray);
    }

    private Object invokeNamedNodeMap(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.equals(ITEM)) {
            int n = (Integer)objectArray[0];
            String string = this.names.get(n);
            int n2 = string.indexOf(0);
            if (n2 < 0) {
                return this.attr.getNamedItem(string);
            }
            String string2 = string.substring(0, n2);
            string = string.substring(n2 + 1);
            return this.attr.getNamedItemNS(string2, string);
        }
        return method.invoke((Object)this.attr, objectArray);
    }

    static {
        try {
            GET_ATTRIBUTES = Node.class.getDeclaredMethod("getAttributes", new Class[0]);
            SET_ATTRIBUTE = Element.class.getDeclaredMethod("setAttribute", String.class, String.class);
            SET_ATTRIBUTE_NS = Element.class.getDeclaredMethod("setAttributeNS", String.class, String.class, String.class);
            SET_ATTRIBUTE_NODE = Element.class.getDeclaredMethod("setAttributeNode", Attr.class);
            SET_ATTRIBUTE_NODE_NS = Element.class.getDeclaredMethod("setAttributeNodeNS", Attr.class);
            REMOVE_ATTRIBUTE = Element.class.getDeclaredMethod("removeAttribute", String.class);
            REMOVE_ATTRIBUTE_NS = Element.class.getDeclaredMethod("removeAttributeNS", String.class, String.class);
            REMOVE_ATTRIBUTE_NODE = Element.class.getDeclaredMethod("removeAttributeNode", Attr.class);
            ITEM = NamedNodeMap.class.getDeclaredMethod("item", Integer.TYPE);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

