/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.koiroha.xml.parser.LocatorReader;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractXMLReader
implements XMLReader {
    private static final Logger logger = Logger.getLogger(AbstractXMLReader.class.getName());
    private final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final Map<String, Object> property = new HashMap<String, Object>();
    private ContentHandler contentHandler = null;
    private DTDHandler dtdHandler = null;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    private Map<String, String> entityReference = new HashMap<String, String>();
    private int maxEntityReferenceLength = 0;
    protected LocatorReader in = null;
    private InputStream mustClose = null;

    protected AbstractXMLReader() {
        this.setEntityReference("lt", "<");
        this.setEntityReference("gt", ">");
        this.setEntityReference("amp", "&");
        this.setEntityReference("quot", "\"");
        this.setEntityReference("apos", "'");
    }

    protected AbstractXMLReader(Map<String, Boolean> map, Map<String, Object> map2) {
        this();
        this.feature.putAll(map);
        this.property.putAll(map2);
    }

    @Override
    public boolean getFeature(String string) {
        return this.getFeature(string, false);
    }

    protected boolean getFeature(String string, boolean bl) {
        Boolean bl2 = this.feature.get(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public boolean isNamespaceAware() {
        return this.getFeature("http://xml.org/sax/features/namespaces", false);
    }

    public boolean isValidating() {
        return this.getFeature("http://xml.org/sax/features/validation");
    }

    @Override
    public void setFeature(String string, boolean bl) {
        this.feature.put(string, bl);
    }

    @Override
    public Object getProperty(String string) {
        return this.property.get(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        logger.finest("setProperty(" + string + "," + object + ")");
        this.property.put(string, object);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return (LexicalHandler)this.getProperty("http://xml.org/sax/properties/lexical-handler");
    }

    public int getMaxEntityReferenceName() {
        return Math.max(this.maxEntityReferenceLength, "#65535".length());
    }

    public void setEntityReference(String string, String string2) {
        this.entityReference.put(string, string2);
        this.maxEntityReferenceLength = Math.max(string.length(), this.maxEntityReferenceLength);
    }

    public void removeEntityReference(String string) {
        this.entityReference.remove(string);
        if (string.length() == this.maxEntityReferenceLength) {
            int n = 0;
            for (String string2 : this.entityReference.keySet()) {
                n = Math.max(string2.length(), n);
            }
            this.maxEntityReferenceLength = n;
        }
    }

    public String getEntityReference(String string) {
        if (string.length() < 2 || string.charAt(0) != '#') {
            return this.entityReference.get(string);
        }
        try {
            int n = -1;
            n = Character.toLowerCase(string.charAt(1)) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
            if (n < 0 || n > 65535) {
                throw new NumberFormatException();
            }
            return String.valueOf((char)n);
        }
        catch (NumberFormatException numberFormatException) {
            return this.entityReference.get(string);
        }
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            this.prepareReader(inputSource);
            ContentHandler contentHandler = this.getContentHandler();
            if (contentHandler == null) {
                contentHandler = new DefaultHandler2();
            }
            contentHandler.setDocumentLocator(this.in);
            contentHandler.startDocument();
            this.handleDocument();
            contentHandler.endDocument();
        }
        finally {
            Toolkit.close(this.mustClose);
        }
    }

    protected abstract void handleDocument() throws SAXException, IOException;

    private void prepareReader(InputSource inputSource) throws IOException, SAXException {
        String string;
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            this.in = new LocatorReader(reader, inputSource.getPublicId(), inputSource.getSystemId());
            this.in.setEncoding(inputSource.getEncoding());
            return;
        }
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream == null) {
            string = inputSource.getSystemId();
            if (string == null) {
                throw new IOException("target system-id or stream not specified in InputSource");
            }
            inputStream = this.mustClose = new URL(string).openStream();
        }
        if ((string = inputSource.getEncoding()) == null) {
            string = "UTF-8";
        }
        this.in = new LocatorReader(new InputStreamReader(inputStream, string), inputSource.getPublicId(), inputSource.getSystemId());
        this.in.setEncoding(string);
    }
}

