/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.koiroha.xml.parser.Toolkit;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class AbstractSAXParserFactory
extends SAXParserFactory {
    private static final Logger logger = Logger.getLogger(AbstractSAXParserFactory.class.getName());
    protected final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private boolean xincludeAware = false;
    private Schema schema = null;

    protected AbstractSAXParserFactory() {
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException {
        Boolean bl = this.feature.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        logger.finest("setFuture(" + string + "," + bl + ")");
        this.feature.put(string, bl);
    }

    @Override
    public boolean isNamespaceAware() {
        try {
            return this.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException);
        }
    }

    @Override
    public void setNamespaceAware(boolean bl) {
        try {
            this.setFeature("http://xml.org/sax/features/namespaces", bl);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException);
        }
    }

    @Override
    public boolean isValidating() {
        try {
            return this.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException);
        }
    }

    @Override
    public void setValidating(boolean bl) {
        try {
            this.setFeature("http://xml.org/sax/features/validation", bl);
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException);
        }
    }

    @Override
    public void setXIncludeAware(boolean bl) {
        this.xincludeAware = bl;
    }

    @Override
    public boolean isXIncludeAware() {
        return this.xincludeAware;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public InputSource guessInpuSource(InputStream inputStream, String string, int n) throws IOException {
        int n2;
        logger.finest("reading " + n + " bytes stream heading to determine stream encoding...");
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (byArray.length - n3 > 0 && (n2 = inputStream.read(byArray, n3, byArray.length - n3)) >= 0) {
            n3 += n2;
        }
        inputStream = new SequenceInputStream(new ByteArrayInputStream(byArray, 0, n3), inputStream);
        String string2 = this.guessEncodingFromPrereadSampling(byArray, n3);
        if (string2 == null || !Charset.isSupported(string2)) {
            logger.finest("encoding is not specified in stream or not supported: " + string2 + ", apply " + string);
            string2 = string;
            if (!Charset.isSupported(string2)) {
                logger.warning("specified encoding is not supported in this environment: " + string2);
                throw new UnsupportedEncodingException(string2);
            }
        }
        logger.finest("creating text reader: " + string2);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
        InputSource inputSource = new InputSource(inputStreamReader);
        inputSource.setEncoding(string2);
        return inputSource;
    }

    protected String guessEncodingFromPrereadSampling(byte[] byArray, int n) {
        if (n >= 2 && ((byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255 || (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254)) {
            logger.finest("byte order mark detected");
            return "Unicode";
        }
        Charset charset = Charset.forName("us-ascii");
        String string = new String(byArray, 0, n, charset);
        return this.guessEncodingFromPrereadSampling(string);
    }

    protected String guessEncodingFromPrereadSampling(String string) {
        Pattern pattern = Pattern.compile("<\\?xml\\s+(.*)\\?>", 32);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            Map<String, String> map = Toolkit.parseAttributesSimply(string2);
            String string3 = map.get("encoding");
            if (string3 == null) {
                string3 = "UTF-8";
            }
            return string3;
        }
        return null;
    }
}

