/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml.parser;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.validation.Schema;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.XMLReaderAdapter;

public abstract class AbstractSAXParser
extends SAXParser {
    protected final Map<String, Boolean> feature = new HashMap<String, Boolean>();
    private final boolean xincludeAware;
    private final Schema schema;
    protected final Map<String, Object> property = new HashMap<String, Object>();

    protected AbstractSAXParser(Map<String, Boolean> map, boolean bl, Schema schema) {
        this.feature.putAll(map);
        this.xincludeAware = bl;
        this.schema = schema;
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.property.get(string);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.property.put(string, object);
    }

    @Override
    public Parser getParser() throws SAXException {
        return new XMLReaderAdapter(this.getXMLReader());
    }

    @Override
    public boolean isNamespaceAware() {
        return this.getFeature("http://xml.org/sax/features/namespaces", false);
    }

    @Override
    public boolean isXIncludeAware() {
        return this.xincludeAware;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public boolean isValidating() {
        return this.getFeature("http://xml.org/sax/features/validation", false);
    }

    private boolean getFeature(String string, boolean bl) {
        Boolean bl2 = this.feature.get(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }
}

