/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Xml {
    private static final Logger logger = Logger.getLogger(Xml.class.getName());
    private static final String FEATURE_PREFIX = "http://xml.org/sax/features/";
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String PROPERTY_PREFIX = "http://xml.org/sax/properties/";
    public static final String PROPERTY_DOCUMENT_XML_VERSION = "http://xml.org/sax/properties/document-xml-version";
    public static final String PROPERTY_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final Pattern CHARSET_ATTRIBUTE = Pattern.compile(";\\s*charset\\s*=\\s*[\"']?([^\"'\\s;]*)[\"']?", 2);
    private static final Pattern ENTITY_REFERENCE = Pattern.compile("&([^;&]*);");

    private Xml() {
    }

    public static boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 13 || n == 10;
    }

    public static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block10;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block10;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append('\n');
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append('\t');
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append('\n');
                    if (i + 1 >= string.length() || string.charAt(i + 1) != '\n') continue block10;
                    ++i;
                    continue block10;
                }
                default: {
                    if (Character.isDefined(c) && !Character.isISOControl(c)) {
                        stringBuilder.append(c);
                        continue block10;
                    }
                    stringBuilder.append("&#" + c + ";");
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        Matcher matcher = ENTITY_REFERENCE.matcher(string);
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            if (n != n2) {
                stringBuilder.append(string, n, n2);
            }
            n = matcher.end();
            String string2 = matcher.group(1);
            if (string2.equals("amp")) {
                stringBuilder.append('&');
                continue;
            }
            if (string2.equals("lt")) {
                stringBuilder.append('<');
                continue;
            }
            if (string2.equals("gt")) {
                stringBuilder.append('>');
                continue;
            }
            if (string2.equals("quot")) {
                stringBuilder.append('\"');
                continue;
            }
            if (string2.equals("apos")) {
                stringBuilder.append('\'');
                continue;
            }
            if (string2.length() > 1 && string2.charAt(0) == '#') {
                boolean bl = string2.length() > 2 && Character.toLowerCase(string2.charAt(1)) == 'x';
                int n3 = 0;
                try {
                    n3 = bl ? Integer.parseInt(string2.substring(2), 16) : Integer.parseInt(string2.substring(1), 10);
                    if (n3 < 0 || n3 > 65535) {
                        throw new NumberFormatException(String.valueOf(n3));
                    }
                    stringBuilder.append((char)n3);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.fine("invalid number entity reference: &" + string2 + ";");
                    stringBuilder.append('&').append(string2).append(';');
                }
                continue;
            }
            logger.fine("unrecognized entity character reference: &" + string2 + ";");
            stringBuilder.append('&').append(string2).append(';');
        }
        if (n != string.length()) {
            stringBuilder.append(string, n, string.length());
        }
        return stringBuilder.toString();
    }

    public static Charset getCharset(String string) {
        logger.finest("getCharset(" + string + ")");
        Matcher matcher = CHARSET_ATTRIBUTE.matcher(string);
        if (!matcher.find()) {
            logger.finest("no charset specified: " + string);
            return null;
        }
        String string2 = matcher.group(1);
        boolean bl = false;
        try {
            bl = Charset.isSupported(string2);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        if (!bl) {
            logger.finest("unsupported charset specified: " + string2 + ": " + string);
            return null;
        }
        logger.finest("charset retrieved: " + string2 + ": " + string);
        return Charset.forName(string2);
    }
}

