/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Html {
    private static final Map<String, Character> ENTITY2CHAR = new HashMap<String, Character>();
    private static final Map<Character, String> CHAR2ENTITY = new HashMap<Character, String>();

    private Html() {
    }

    public static int getCharacter(String string) {
        Character c = ENTITY2CHAR.get(string);
        if (c == null) {
            return -1;
        }
        return c.charValue();
    }

    public static String getEntityReference(char c) {
        String string = CHAR2ENTITY.get(Character.valueOf(c));
        if (string != null) {
            return string;
        }
        return "&#x" + Integer.toHexString(c).toUpperCase() + ";";
    }

    public static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile("&[^;&]+;");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            stringBuilder.append(string.substring(n, n2));
            n = matcher.end();
            String string2 = string.substring(n2, n);
            int n3 = Html.getCharacter(string2);
            if (n3 < 0) {
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append((char)n3);
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.koiroha.xml.htmlentity");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = resourceBundle.getString(string);
            String string3 = "&" + string + ";";
            Character c = Character.valueOf((char)Integer.parseInt(string2));
            ENTITY2CHAR.put(string3, c);
            CHAR2ENTITY.put(c, string3);
        }
    }
}

