/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;

public class DefaultNamespaceContext
implements NamespaceContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(DefaultNamespaceContext.class.getName());
    private final NamespaceContext parent;
    private final Map<String, String> namespace = new HashMap<String, String>();

    public DefaultNamespaceContext() {
        this(null);
    }

    public DefaultNamespaceContext(NamespaceContext namespaceContext) {
        this.parent = namespaceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaceURI(String string, String string2) throws IllegalArgumentException {
        logger.finest("setNamespaceURI(" + string + "," + string2 + ")");
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("prefix or namespace-uri is null");
        }
        if (string.equals("xml") && !string2.equals("http://www.w3.org/XML/1998/namespace") || string.equals("xmlns") && !string2.equals("http://www.w3.org/2000/xmlns/")) {
            throw new IllegalArgumentException("specified prefix is reserved: " + string);
        }
        Map<String, String> map = this.namespace;
        synchronized (map) {
            this.namespace.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        Map<String, String> map = this.namespace;
        synchronized (map) {
            if (this.namespace.containsKey(string)) {
                return this.namespace.get(string);
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(string);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        Map<String, String> map = this.namespace;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.namespace.entrySet()) {
                if (!string.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        if (this.parent != null) {
            return this.parent.getPrefix(string);
        }
        if (string.equals("")) {
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getPrefixes(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("xml");
            return arrayList.iterator();
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("xmlns");
            return arrayList.iterator();
        }
        HashSet<String> hashSet = new HashSet<String>();
        Object object = this.namespace;
        synchronized (object) {
            for (Map.Entry<String, String> entry : this.namespace.entrySet()) {
                if (!string.equals(entry.getValue())) continue;
                hashSet.add(entry.getKey());
            }
        }
        if (this.parent != null) {
            object = this.parent.getPrefixes(string);
            while (object.hasNext()) {
                hashSet.add((String)object.next());
            }
        }
        return hashSet.iterator();
    }
}

