/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.binedit;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.koiroha.binedit.Command;

class HexModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private File file = null;
    private byte[] binary = new byte[0];
    private int length = 0;
    private boolean modified = false;
    private final List<Command> history = new ArrayList<Command>();
    private int historyPointer = 0;
    private final PropertyChangeSupport listener = new PropertyChangeSupport(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file) throws IOException {
        int n = this.getRowCount();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[1024];
        try {
            int n2;
            fileInputStream = new FileInputStream(file);
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            this.binary = byteArrayOutputStream.toByteArray();
            this.setFile(file);
            this.setLength(this.binary.length);
            this.setModified(false);
            this.history.clear();
            this.historyPointer = 0;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        int n3 = this.getRowCount();
        if (n > 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        if (n3 > 0) {
            this.fireTableRowsInserted(0, n3 - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(this.binary, 0, this.length);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setFile(file);
        this.setModified(false);
    }

    public int getIndex(int n, int n2) {
        if (n2 == 0 || n2 == 17) {
            return -1;
        }
        int n3 = n * 16 + (n2 - 1);
        if (n3 >= this.getLength()) {
            return -1;
        }
        return n3;
    }

    public void delete(int ... nArray) {
        if (nArray.length == 0) {
            return;
        }
        Command command = null;
        if (nArray.length == 1) {
            command = new Command.Delete(nArray[0], 1);
        } else {
            Arrays.sort(nArray);
            Command.Complex complex = new Command.Complex();
            for (int i = nArray.length - 1; i > 0; --i) {
                int n;
                for (n = i - 1; n > 0 && nArray[n - 1] == nArray[n] - 1; --n) {
                }
                if (nArray[i] + 1 < this.binary.length) {
                    complex.add(new Command.Delete(nArray[n], nArray[i] - nArray[n] + 1));
                }
                i = n - 1;
            }
            command = complex;
        }
        this.exec(command, false, false);
    }

    public void insert(int ... nArray) {
        if (nArray.length == 0) {
            return;
        }
        this.ensureCapacity(this.binary.length + nArray.length);
        Command command = null;
        if (nArray.length == 1) {
            command = new Command.Insert(nArray[0], 1);
        } else {
            Arrays.sort(nArray);
            Command.Complex complex = new Command.Complex();
            for (int i = nArray.length - 1; i > 0; --i) {
                int n;
                for (n = i - 1; n > 0 && nArray[n - 1] == nArray[n] - 1; --n) {
                }
                if (nArray[i] + 1 < this.binary.length) {
                    complex.add(new Command.Insert(nArray[n], nArray[i] - nArray[n] + 1));
                }
                i = n - 1;
            }
            command = complex;
        }
        this.exec(command, false, false);
    }

    public int undo() {
        if (this.historyPointer == 0) {
            return -1;
        }
        Command command = this.history.get(this.historyPointer - 1);
        this.exec(command, true, false);
        return command.getOffset();
    }

    public int redo() {
        if (this.historyPointer == this.history.size()) {
            return -1;
        }
        Command command = this.history.get(this.historyPointer);
        this.exec(command, false, true);
        return command.getOffset();
    }

    private void exec(Command command, boolean bl, boolean bl2) {
        int n;
        int n2 = this.getRowCount();
        int n3 = n = bl ? command.undo(this.binary, this.length) : command.exec(this.binary, this.length);
        if (!bl && !bl2) {
            while (this.historyPointer < this.history.size()) {
                this.history.remove(this.historyPointer);
            }
            this.history.add(this.historyPointer, command);
        }
        this.historyPointer = bl ? --this.historyPointer : ++this.historyPointer;
        this.setLength(n);
        this.setModified(true);
        int n4 = this.getRowCount();
        int n5 = command.getOffset() / 16;
        int n6 = Math.min(n4, n2);
        if (n6 > 0) {
            this.fireTableRowsUpdated(n5, n6 - 1);
        }
        if (n4 > n2) {
            this.fireTableRowsInserted(n2, n4 - 1);
        } else if (n4 < n2) {
            this.fireTableRowsDeleted(n4, n2 - 1);
        }
    }

    public int getColumnCount() {
        return 18;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "";
        }
        if (n == 17) {
            return "ASCII";
        }
        return String.format("%02X", n - 1);
    }

    public int getRowCount() {
        return this.length / 16 + 1;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return String.format("%05X", n * 16);
        }
        if (n2 == 17) {
            int n3 = n * 16;
            int n4 = Math.min(16, this.length - n3);
            return this.getASCII(n3, n4);
        }
        int n5 = n * 16 + (n2 - 1);
        if (n5 == this.length) {
            return "";
        }
        if (n5 >= this.length) {
            return null;
        }
        byte by = this.binary[n5];
        return String.format("%02X", by);
    }

    public void setValueAt(Object object, int n, int n2) {
        int n3 = 0;
        try {
            n3 = Integer.parseInt(object.toString(), 16);
            if (n3 < 0 || n3 > 255) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        int n4 = this.getIndex(n, n2);
        if (n3 != this.binary[n4]) {
            Command.Change change = new Command.Change(n4, (byte)n3);
            this.exec(change, false, false);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 >= 1 && n2 <= 16;
    }

    public ByteBuffer getByteBuffer(int n, int n2, ByteOrder byteOrder) {
        if (n + n2 >= this.length) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.binary, n, n2);
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        byteBuffer.order(byteOrder);
        return byteBuffer;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File file2 = this.file;
        File file3 = file;
        this.file = file;
        this.listener.firePropertyChange("file", file2, file3);
    }

    public int getLength() {
        return this.length;
    }

    private void setLength(int n) {
        Integer n2 = this.length;
        Integer n3 = n;
        this.length = n;
        this.listener.firePropertyChange("length", n2, n3);
    }

    public boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean bl) {
        Boolean bl2 = this.modified;
        Boolean bl3 = bl;
        this.modified = bl;
        this.listener.firePropertyChange("modified", bl2, bl3);
    }

    private String getASCII(int n, int n2) {
        assert (n + n2 <= this.length);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            byte by;
            if (i == 8) {
                stringBuilder.append(' ');
            }
            if ((by = this.binary[n + i]) >= 32 && by < 127) {
                stringBuilder.append((char)by);
                continue;
            }
            stringBuilder.append("\u00b7");
        }
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (this.binary.length >= n) {
            return;
        }
        byte[] byArray = new byte[this.binary.length + 64];
        System.arraycopy(this.binary, 0, byArray, 0, this.binary.length);
        this.binary = byArray;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener.addPropertyChangeListener(propertyChangeListener);
    }

    public static class Renderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Color evenColor = new Color(0xF0F0FF);
        private final Color outOfBounds = new Color(0xF0F0F0);

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 0, 1, Color.BLACK);
                this.setBorder(matteBorder);
            } else {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            if (object == null) {
                this.setBackground(this.outOfBounds);
            } else if (n % 2 == 1) {
                this.setBackground(this.evenColor);
            } else {
                this.setBackground(jTable.getBackground());
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

